/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher.loader;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingsHandler {
    private File out;
    private Boolean cached = false;
    private String resource = null;
    private HashMap<String, String> cache;
    private InputStream input = null;

    public SettingsHandler(String resource, String out) {
        this.resource = resource;
        this.out = new File(out);
    }

    public SettingsHandler(String resource, File out) {
        this.resource = resource;
        this.out = out;
    }

    public SettingsHandler(InputStream input, File out) {
        this.input = input;
        this.out = out;
    }

    public SettingsHandler(File out) throws FileNotFoundException {
        if (!out.exists()) {
            throw new FileNotFoundException("The out does not exist.");
        }
        this.out = out;
    }

    public Boolean isCached() {
        return this.cached;
    }

    public void setCached(Boolean cached) {
        this.cached = cached;
        this.cached = false;
        if (this.cached.booleanValue()) {
            this.cache = null;
        }
    }

    private void create(String resource) {
        InputStream input = this.getClass().getResourceAsStream(resource);
        if (input != null) {
            FileOutputStream output = null;
            try {
                try {
                    int length;
                    this.out.getParentFile().mkdirs();
                    output = new FileOutputStream(this.out);
                    byte[] buf = new byte[8192];
                    while ((length = input.read(buf)) > 0) {
                        output.write(buf, 0, length);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        input.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (output != null) {
                            output.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    input.close();
                }
                catch (Exception exception) {}
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private void create(InputStream input) {
        if (input != null) {
            FileOutputStream output = null;
            try {
                try {
                    int length;
                    output = new FileOutputStream(this.out);
                    byte[] buf = new byte[8192];
                    while ((length = input.read(buf)) > 0) {
                        output.write(buf, 0, length);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        input.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (output != null) {
                            output.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    input.close();
                }
                catch (Exception exception) {}
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private HashMap<String, String> loadHashMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(this.out));
            while ((line = br.readLine()) != null) {
                if (line.isEmpty() || line.startsWith("#") || !line.contains(": ")) continue;
                String[] args = line.split(": ");
                if (args.length < 2) {
                    result.put(args[0], null);
                    continue;
                }
                result.put(args[0], args[1]);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void load() {
        if (this.resource != null && !this.out.exists()) {
            this.create(this.resource);
        }
        if (this.input != null && !this.out.exists()) {
            this.create(this.input);
        }
        if (this.cached.booleanValue()) {
            this.cache = this.loadHashMap();
        }
    }

    public String getPropertyString(String property) {
        try {
            if (this.cached.booleanValue()) {
                return this.cache.get(property);
            }
            HashMap<String, String> contents = this.loadHashMap();
            return contents.get(property);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Integer getPropertyInteger(String property) {
        try {
            if (this.cached.booleanValue()) {
                return Integer.parseInt(this.cache.get(property));
            }
            HashMap<String, String> contents = this.loadHashMap();
            return Integer.parseInt(contents.get(property));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Boolean getPropertyBoolean(String property) {
        try {
            String result;
            if (this.cached.booleanValue()) {
                result = this.cache.get(property);
            } else {
                HashMap<String, String> contents = this.loadHashMap();
                result = contents.get(property);
            }
            if (result != null && result.equalsIgnoreCase("true")) {
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Double getPropertyDouble(String property) {
        try {
            String result;
            if (this.cached.booleanValue()) {
                result = this.cache.get(property);
            } else {
                HashMap<String, String> contents = this.loadHashMap();
                result = contents.get(property);
            }
            if (!result.contains(".")) {
                result = String.valueOf(result) + ".0";
            }
            return Double.parseDouble(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Boolean checkProperty(String property) {
        try {
            String check;
            if (this.cached.booleanValue()) {
                check = this.cache.get(property);
            } else {
                HashMap<String, String> contents = this.loadHashMap();
                check = contents.get(property);
            }
            if (check != null) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private void flush(HashMap<Integer, String> newContents) {
        try {
            this.delFile(this.out);
            this.out.createNewFile();
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.out));
            int i = 1;
            while (i <= newContents.size()) {
                String line = newContents.get(i);
                if (line == null) {
                    writer.append("\n");
                } else {
                    writer.append(line);
                    writer.append("\n");
                }
                ++i;
            }
            writer.flush();
            writer.close();
            if (this.cached.booleanValue()) {
                this.load();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void delFile(File file) {
        if (file.exists()) {
            file.delete();
        }
    }

    private HashMap<Integer, String> getAllFileContents() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        Integer i = 1;
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(this.out));
            while ((line = br.readLine()) != null) {
                if (line.isEmpty()) {
                    result.put(i, null);
                    i = i + 1;
                    continue;
                }
                result.put(i, line);
                i = i + 1;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void insertComment(String comment) {
        HashMap<Integer, String> contents = this.getAllFileContents();
        contents.put(contents.size() + 1, "#" + comment);
        this.flush(contents);
    }

    public void insertComment(String comment, Integer line) {
        HashMap<Integer, String> contents = this.getAllFileContents();
        if (line >= contents.size() + 1) {
            return;
        }
        HashMap<Integer, String> newContents = new HashMap<Integer, String>();
        int i = 1;
        while (i < line) {
            newContents.put(i, contents.get(i));
            ++i;
        }
        newContents.put(line, "#" + comment);
        i = line;
        while (i <= contents.size()) {
            newContents.put(i + 1, contents.get(i));
            ++i;
        }
        this.flush(newContents);
    }

    public void put(String property, Object obj) {
        HashMap<Integer, String> contents = this.getAllFileContents();
        contents.put(contents.size() + 1, String.valueOf(property) + ": " + obj.toString());
        this.flush(contents);
    }

    public void put(String property, Object obj, Integer line) {
        HashMap<Integer, String> contents = this.getAllFileContents();
        if (line >= contents.size() + 1) {
            return;
        }
        HashMap<Integer, String> newContents = new HashMap<Integer, String>();
        int i = 1;
        while (i < line) {
            newContents.put(i, contents.get(i));
            ++i;
        }
        newContents.put(line, String.valueOf(property) + ": " + obj.toString());
        i = line;
        while (i <= contents.size()) {
            newContents.put(i + 1, contents.get(i));
            ++i;
        }
        this.flush(newContents);
    }

    public void changeProperty(String property, Object obj) {
        HashMap<Integer, String> contents = this.getAllFileContents();
        if (contents == null) {
            return;
        }
        int i = 1;
        while (i <= contents.size()) {
            String check;
            if (contents.get(i) != null && (check = contents.get(i)).startsWith(property) && (check = check.replace(property, "")).startsWith(": ")) {
                contents.remove(i);
                contents.put(i, String.valueOf(property) + ": " + obj.toString());
            }
            ++i;
        }
        this.flush(contents);
    }

    public Integer getLineCount() {
        HashMap<Integer, String> contents = this.getAllFileContents();
        return contents.size();
    }
}

