/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher.loader;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.SocketException;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.craftland.launcher.loader.Download;
import org.craftland.launcher.loader.PlatformUtils;
import org.craftland.launcher.loader.SettingsHandler;
import org.craftland.launcher.loader.VersionHandler;

public class MainLauncher
extends JFrame {
    private static final long serialVersionUID = -1538787934752760335L;
    static String[] args_temp;
    public static SettingsHandler settings;
    private static MainLauncher mainFrame;
    private VersionHandler version;
    private final JProgressBar progressBar;
    private JPanel contentPane = new JPanel();
    public JLabel status = new JLabel();
    public static volatile boolean forceUpdate;
    public static boolean preferIPV4;
    static String command;

    static {
        forceUpdate = false;
        preferIPV4 = false;
        command = "java";
    }

    public MainLauncher() {
        this.version = new VersionHandler();
        Rectangle dim = this.getGraphicsConfiguration().getBounds();
        int x = 350;
        int y = 90;
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(MainLauncher.class.getResource("/org/craftland/launcher/loader/favicon.png")));
        this.setResizable(false);
        this.setTitle("Craftland LauncherLoader");
        this.setDefaultCloseOperation(3);
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(null);
        this.status.setText("Checking for new launcher version");
        this.contentPane.add(this.status);
        this.contentPane.add(this.progressBar);
        this.setBounds((dim.width - x) / 2, (dim.height - y) / 2, x, y);
        this.progressBar.setBounds(15, y - 55, x - 30, 24);
        this.status.setBounds(15, 8, x - 30, 20);
        this.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            int i = 0;
            while (i < args.length) {
                if (args[i].equalsIgnoreCase("--portable")) {
                    PlatformUtils.setPortable(true);
                } else if (args[i].equals("--url") & i + 1 < args.length) {
                    VersionHandler.launcherURL = args[++i].replaceAll("'|\"", "");
                    System.out.println("Using custom launcher url '" + VersionHandler.launcherURL + "'");
                } else if (args[i].equals("--preferipv4")) {
                    preferIPV4 = true;
                }
                ++i;
            }
            args_temp = args;
            MainLauncher.initSettings();
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            mainFrame = new MainLauncher();
            mainFrame.setVisible(true);
            mainFrame.onLoad();
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), e.getClass().getSimpleName(), 0);
        }
    }

    private static void initSettings() {
        new File(PlatformUtils.getWorkingDirectory(), "config").mkdirs();
        File oldFile = new File(PlatformUtils.getWorkingDirectory(), "mods" + File.separator + "craftland" + File.separator + "craftland.properties");
        File launcherProperties = new File(PlatformUtils.getWorkingDirectory(), "config" + File.separator + "launcher.properties");
        if (oldFile.exists()) {
            oldFile.renameTo(launcherProperties);
        }
        settings = new SettingsHandler("/defaults/craftland.properties", launcherProperties);
        settings.load();
    }

    private void onLoad() {
        Thread updateThread = new Thread(new Runnable(){

            public void run() {
                block23: {
                    File versionFile;
                    boolean update;
                    block22: {
                        update = !MainLauncher.getJarPath().exists();
                        double local = 0.0;
                        versionFile = new File(PlatformUtils.getWorkingDirectory(), "launcherversion.txt");
                        try {
                            Thread.sleep(600L);
                            if (forceUpdate || update) {
                                if (MainLauncher.getJarPath().exists()) {
                                    JOptionPane.showMessageDialog(MainLauncher.this, "Forcing update!", "Loader", 1);
                                }
                                if (versionFile.exists()) {
                                    versionFile.delete();
                                }
                            }
                            MainLauncher.this.version.loadVersions(MainLauncher.this);
                        }
                        catch (SocketException e) {
                            int result;
                            if (e.getMessage().toLowerCase().contains("invalid argument") && (result = JOptionPane.showConfirmDialog(null, "Can't load versions.txt\nRestart with ipv6 fix?", "Can't load versions.txt", 0)) == 0) {
                                preferIPV4 = true;
                                try {
                                    MainLauncher.reboot(true);
                                }
                                catch (Exception e1) {
                                    e1.printStackTrace();
                                }
                            }
                            MainLauncher.this.setAlwaysOnTop(false);
                            JOptionPane.showMessageDialog(MainLauncher.this, e.getMessage(), "Can't load versions.txt", 0);
                            return;
                        }
                        catch (Exception e) {
                            MainLauncher.this.setAlwaysOnTop(false);
                            JOptionPane.showMessageDialog(MainLauncher.this, e.getMessage(), "Can't load versions.txt", 0);
                            return;
                        }
                        if (versionFile.exists()) {
                            try {
                                local = Double.parseDouble(VersionHandler.readVersionFile(versionFile));
                                if (local == MainLauncher.this.version.getVersion("newlauncher")) {
                                    update = false;
                                    break block22;
                                }
                                update = true;
                            }
                            catch (Exception e) {
                                MainLauncher.this.setAlwaysOnTop(false);
                                JOptionPane.showMessageDialog(MainLauncher.this, e.getMessage(), "Can't read " + versionFile.getPath(), 0);
                                update = true;
                            }
                        } else {
                            update = true;
                        }
                    }
                    if (update) {
                        MainLauncher.this.status.setText("New launcher version found: " + MainLauncher.this.version.getVersion("newlauncher"));
                        String url = MainLauncher.this.version.getURL("newlauncher");
                        try {
                            File launcher = MainLauncher.getJarPath();
                            if (launcher.exists()) {
                                launcher.delete();
                            }
                            Download launcherDownload = new Download(MainLauncher.this, url, launcher.getPath());
                            launcherDownload.load();
                            if (launcher.exists()) {
                                VersionHandler.writeVersionFile(versionFile, String.valueOf(MainLauncher.this.version.getVersion("newlauncher")));
                                MainLauncher.reboot(true);
                                break block23;
                            }
                            MainLauncher.this.status.setForeground(Color.RED);
                            MainLauncher.this.status.setText("Update failed!");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            MainLauncher.this.status.setForeground(Color.RED);
                            MainLauncher.this.status.setText("Update failed!");
                            MainLauncher.this.setAlwaysOnTop(false);
                            JOptionPane.showMessageDialog(MainLauncher.this, String.valueOf(e.getMessage()) + " while loading " + url, "Update failed", 0);
                        }
                    } else {
                        String javaname = "Java " + System.getProperty("java.version") + " " + System.getProperty("os.arch");
                        MainLauncher.this.status.setText("Starting launcher (" + javaname + ")");
                        try {
                            MainLauncher.reboot(false);
                        }
                        catch (Throwable e) {
                            JOptionPane.showMessageDialog(null, e.getMessage(), e.getClass().getSimpleName(), 0);
                        }
                    }
                }
            }
        });
        updateThread.setDaemon(true);
        updateThread.start();
    }

    public static File getJarPath() {
        return new File(PlatformUtils.getWorkingDirectory(), "launcher.jar");
    }

    public static void reboot(boolean nag) throws Exception {
        int result;
        int n = result = nag ? JOptionPane.showConfirmDialog(null, "The launcher needs to be restarted to apply changes.\nRestart now?", "Launcher updated", 0) : 0;
        if (result == 0) {
            File f;
            ArrayList<String> params = new ArrayList<String>();
            String commandName = null;
            String javaHome = System.getProperty("launcher.jredir");
            if (javaHome != null && (f = new File(javaHome, "bin")).isDirectory()) {
                commandName = String.valueOf(f.getAbsolutePath()) + File.separator + "java";
            }
            if (commandName == null) {
                commandName = "java";
            }
            params.add(commandName);
            if (preferIPV4) {
                params.add("-Djava.net.preferIPv4Stack=true");
                params.add("-Djava.net.preferIPv6Addresses=false");
            }
            if (PlatformUtils.getPlatform() == PlatformUtils.OS.macos) {
                params.add("-Xdock:name=Craftland");
            }
            params.add("-classpath");
            params.add(MainLauncher.getJarPath().getPath());
            params.add("org.craftland.launcher.Main");
            String[] stringArray = args_temp;
            int n2 = args_temp.length;
            int n3 = 0;
            while (n3 < n2) {
                String arg = stringArray[n3];
                params.add(arg);
                ++n3;
            }
            if (preferIPV4) {
                params.add("--preferipv4");
            }
            ProcessBuilder pb = new ProcessBuilder(params).redirectErrorStream(true);
            Process process = pb.start();
            Thread.sleep(400L);
            if (process == null) {
                throw new Exception("!");
            }
            BufferedReader is = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            boolean goodstart = false;
            String response = "";
            while ((line = is.readLine()) != null) {
                if (line.equalsIgnoreCase("OK_OK")) {
                    goodstart = true;
                    break;
                }
                response = String.valueOf(response) + line + "\n";
            }
            is.close();
            if (!goodstart) {
                JOptionPane.showMessageDialog(null, "Failed to start Java Process.\nPlease report this error" + (response.isEmpty() ? "" : ":\n" + response), "Failed to start", 2);
                File versionFile = new File(PlatformUtils.getWorkingDirectory(), "launcherversion.txt");
                VersionHandler.writeVersionFile(versionFile, String.valueOf(0));
            }
            System.exit(0);
        }
    }

    public void stateChanged(String fileName, float progress) {
        int intProgress = Math.round(progress);
        this.progressBar.setValue(intProgress);
        this.progressBar.setString(String.valueOf(intProgress) + "% " + fileName);
    }
}

