/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher.loader;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.craftland.launcher.loader.MainLauncher;

public class Download {
    private static final int BUFFER = 1024;
    private URL url;
    private int size = -1;
    private int downloaded = 0;
    private String outPath;
    private final MainLauncher listener;

    public Download(MainLauncher listener, String url, String outPath) throws MalformedURLException {
        this.url = new URL(url);
        this.outPath = outPath;
        this.listener = listener;
    }

    public float getProgress() {
        return (float)this.downloaded / (float)this.size * 100.0f;
    }

    public void load() throws IOException {
        RandomAccessFile file = null;
        InputStream stream = null;
        try {
            byte[] buffer;
            int read;
            HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
            connection.setRequestProperty("Range", "bytes=" + this.downloaded + "-");
            connection.connect();
            if (connection.getResponseCode() / 100 != 2) {
                throw new IOException("Incorrect response code: " + connection.getResponseCode());
            }
            int contentLength = connection.getContentLength();
            if (contentLength < 1) {
                int length;
                if (this.listener != null) {
                    this.listener.stateChanged(this.outPath, 0.0f);
                }
                stream = connection.getInputStream();
                FileOutputStream out = new FileOutputStream(this.outPath);
                byte[] buffer2 = new byte[1024];
                while ((length = stream.read(buffer2)) > 0) {
                    out.write(buffer2, 0, length);
                }
                stream.close();
                out.close();
                if (this.listener != null) {
                    this.listener.stateChanged(this.outPath, 100.0f);
                }
                return;
            }
            if (this.size == -1) {
                this.size = contentLength;
                this.stateChanged();
            }
            file = new RandomAccessFile(this.outPath, "rw");
            file.seek(this.downloaded);
            stream = connection.getInputStream();
            while ((read = stream.read(buffer = this.size - this.downloaded > 1024 ? new byte[1024] : new byte[this.size - this.downloaded])) != -1) {
                file.write(buffer, 0, read);
                this.downloaded += read;
                this.stateChanged();
            }
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (Exception exception) {}
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void stateChanged() {
        if (this.listener != null) {
            this.listener.stateChanged(this.outPath, this.getProgress());
        }
    }
}

