/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher.loader;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.PublicKey;
import java.security.cert.Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.swing.JProgressBar;

public class PlatformUtils {
    private static boolean portable;
    private static File workDir;

    public static File getWorkingDirectory() {
        if (workDir == null) {
            workDir = PlatformUtils.getWorkingDirectory("craftland");
        }
        return workDir;
    }

    public static File getVanillaWorkingDirectory() {
        if (workDir == null) {
            workDir = PlatformUtils.getWorkingDirectory("minecraft");
        }
        return workDir;
    }

    public static File getWorkingDirectory(String applicationName) {
        File workingDirectory;
        if (portable) {
            File fPortable = new File(applicationName);
            System.setProperty("craftlandPortable", fPortable.getAbsolutePath());
            return fPortable;
        }
        String userHome = System.getProperty("user.home", ".");
        switch (PlatformUtils.getPlatform()) {
            case linux: 
            case solaris: {
                workingDirectory = new File(userHome, '.' + applicationName + '/');
                break;
            }
            case windows: {
                String applicationData = System.getenv("APPDATA");
                if (applicationData != null) {
                    workingDirectory = new File(applicationData, "." + applicationName + '/');
                    break;
                }
                workingDirectory = new File(userHome, '.' + applicationName + '/');
                break;
            }
            case macos: {
                workingDirectory = new File(userHome, "Library/Application Support/" + applicationName);
                break;
            }
            default: {
                workingDirectory = new File(userHome, applicationName + '/');
            }
        }
        if (!workingDirectory.exists() && !workingDirectory.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + workingDirectory);
        }
        return workingDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String excutePost(String targetURL, String urlParameters, int timeOut) throws IOException {
        HttpURLConnection connection = null;
        try {
            String str1;
            String line;
            URL url = new URL(targetURL);
            connection = (HttpsURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("Content-Length", Integer.toString(urlParameters.getBytes().length));
            connection.setRequestProperty("Content-Language", "en-US");
            if (timeOut > 0) {
                connection.setConnectTimeout(timeOut);
                connection.setReadTimeout(timeOut);
            }
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.connect();
            Certificate[] certs = ((HttpsURLConnection)connection).getServerCertificates();
            byte[] bytes = new byte[294];
            DataInputStream dis = new DataInputStream(PlatformUtils.class.getResourceAsStream("minecraft.key"));
            dis.readFully(bytes);
            dis.close();
            Certificate c = certs[0];
            PublicKey pk = c.getPublicKey();
            byte[] data = pk.getEncoded();
            for (int i = 0; i < data.length; ++i) {
                if (data[i] == bytes[i]) continue;
                throw new RuntimeException("Public key mismatch");
            }
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            wr.writeBytes(urlParameters);
            wr.flush();
            wr.close();
            InputStream is = connection.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(is));
            StringBuffer response = new StringBuffer();
            while ((line = rd.readLine()) != null) {
                response.append(line);
                response.append('\r');
            }
            rd.close();
            String string = str1 = response.toString();
            return string;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static OS getPlatform() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return OS.windows;
        }
        if (osName.contains("mac")) {
            return OS.macos;
        }
        if (osName.contains("solaris")) {
            return OS.solaris;
        }
        if (osName.contains("sunos")) {
            return OS.solaris;
        }
        if (osName.contains("linux")) {
            return OS.linux;
        }
        if (osName.contains("unix")) {
            return OS.linux;
        }
        return OS.unknown;
    }

    public static boolean isPortable() {
        return portable;
    }

    public static void setPortable(boolean portable) {
        PlatformUtils.portable = portable;
        workDir = PlatformUtils.getWorkingDirectory("craftland");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String excutePost(String targetURL, String urlParameters, JProgressBar progress) {
        HttpURLConnection connection = null;
        try {
            String line;
            URL url = new URL(targetURL);
            connection = (HttpsURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("Content-Length", Integer.toString(urlParameters.getBytes().length));
            connection.setRequestProperty("Content-Language", "en-US");
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setConnectTimeout(10000);
            connection.connect();
            Certificate[] certs = ((HttpsURLConnection)connection).getServerCertificates();
            byte[] bytes = new byte[294];
            DataInputStream dis = new DataInputStream(PlatformUtils.class.getResourceAsStream("minecraft.key"));
            dis.readFully(bytes);
            dis.close();
            Certificate c = certs[0];
            PublicKey pk = c.getPublicKey();
            byte[] data = pk.getEncoded();
            for (int j = 0; j < data.length; ++j) {
                if (data[j] == bytes[j]) continue;
                throw new RuntimeException("Public key mismatch");
            }
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            wr.writeBytes(urlParameters);
            wr.flush();
            wr.close();
            InputStream is = connection.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(is));
            StringBuilder response = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                response.append(line);
                response.append('\r');
            }
            rd.close();
            String string = response.toString();
            return string;
        }
        catch (Exception e) {
            String message = "Login failed...";
            progress.setString(message);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return null;
    }

    static {
        workDir = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OS {
        linux,
        solaris,
        windows,
        macos,
        unknown;

    }
}

