/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Map;
import org.craftland.launcher.WorkingDirectory;

public class LauncherSettings {
    private static final LauncherSettings instance = new LauncherSettings();
    private HashMap<String, String> map = new HashMap();

    public static LauncherSettings getInstance() {
        return instance;
    }

    private File getFile() {
        return new File(WorkingDirectory.getWorkingDirectory(), "config" + File.separator + "launcher.properties");
    }

    public synchronized void load() {
        File f = this.getFile();
        HashMap<String, String> load = new HashMap<String, String>();
        try {
            if (f.exists()) {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(f));
                while ((line = br.readLine()) != null) {
                    String[] args;
                    if (line.isEmpty() || line.startsWith("#") || !line.contains(": ") || (args = line.split(": ")).length <= 1) continue;
                    load.put(args[0], args[1]);
                }
                br.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.map = load;
    }

    public synchronized void write() {
        File f = this.getFile();
        f.getParentFile().mkdirs();
        try {
            if (f.exists()) {
                f.delete();
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(f));
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                String line = entry.getKey() + ": " + entry.getValue() + "\n";
                writer.append(line);
            }
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void setInteger(String string, Integer m) {
        this.map.put(string, String.valueOf(m == null ? 0 : m));
        this.write();
    }

    public synchronized void setBoolean(String string, Boolean m) {
        this.map.put(string, m != null && m != false ? "true" : "false");
        this.write();
    }

    public synchronized void setString(String string, String m) {
        this.map.put(string, String.valueOf(m));
        this.write();
    }

    public synchronized int getInt(String string, int i) {
        String s = this.map.get(string);
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public synchronized Integer getInt(String string) {
        return this.getInt(string, 0);
    }

    public synchronized String getString(String string) {
        String s = this.map.get(string);
        return s;
    }

    public synchronized String getString(String string, String def) {
        String s = this.map.get(string);
        return s == null ? def : s;
    }

    public synchronized boolean getBoolean(String optionName, boolean def) {
        String s = this.map.get(optionName);
        if (s != null) {
            try {
                return Boolean.parseBoolean(s);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return def;
    }

    public synchronized boolean getBoolean(String string) {
        return this.getBoolean(string, false);
    }
}

