/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import org.craftland.launcher.LoginState;
import org.craftland.launcher.WorkingDirectory;
import org.craftland.launcher.accounts.Account;
import org.craftland.launcher.guifx.LoginController;
import org.craftland.launcher.mojang.YggdrasilAccount;
import org.craftland.launcher.updater.GameUpdater;
import org.craftland.util.UpdateUtils;

public class LoginThread
extends Thread {
    private LoginState loginState;
    private final LoginController login;
    private String message;
    public boolean startGame;
    private boolean keepOpen;
    int memory = 0;
    String jvmArgs = null;
    Account auth = null;
    boolean skipAuth = false;
    public Throwable lastException = null;

    public LoginThread(LoginController login) {
        super("LoginThread");
        this.setPriority(5);
        this.login = login;
    }

    public void setKeepOpen(boolean keepOpen) {
        this.keepOpen = keepOpen;
    }

    public void setStartGame(boolean startGame) {
        this.startGame = startGame;
    }

    public void setJvmArgs(String jvmArgs) {
        this.jvmArgs = jvmArgs;
    }

    public void setAuth(Account storedAuth) {
        this.auth = storedAuth;
    }

    public void setSkipAuth(boolean skipAuth) {
        this.skipAuth = skipAuth;
    }

    public void setMemory(int memory) {
        this.memory = memory;
    }

    private void checkUpdate() throws Exception {
        File gameJar;
        if (!WorkingDirectory.getWorkingDirectory().exists()) {
            WorkingDirectory.getWorkingDirectory().mkdirs();
        }
        this.setMessage("Checking for mod update...");
        if (!GameUpdater.binDir.isDirectory()) {
            GameUpdater.resetStateSoft();
        }
        if (!(gameJar = GameUpdater.getGameJar()).exists()) {
            GameUpdater.getGameUpdateFile().deleteVersion();
        } else if (!UpdateUtils.validateZipFileIntegrity(gameJar)) {
            GameUpdater.getGameUpdateFile().deleteVersion();
        }
        File lwjglJar = new File(GameUpdater.binDir, "lwjgl.jar");
        if (!lwjglJar.exists()) {
            GameUpdater.lwjglUpdateFile.deleteVersion();
        } else if (!UpdateUtils.validateZipFileIntegrity(lwjglJar)) {
            GameUpdater.lwjglUpdateFile.deleteVersion();
        }
        if (!GameUpdater.modUpdateFileStable.needsUpdate() && !GameUpdater.resUpdateFile.needsUpdate()) {
            this.setMessage("Craftland-mod is up to date (v" + GameUpdater.modUpdateFileStable.getLocalVersion() + ")");
        } else {
            this.setMessage("Need to update: mod v" + GameUpdater.modUpdateFileStable.getRemoteVersion() + "/ resources v" + GameUpdater.resUpdateFile.getRemoteVersion() + ". Please login");
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 9 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setLoginState(LoginState loginState, String string) {
        this.loginState = loginState;
        this.message = string;
        this.updateGUI();
    }

    public void setMessage(String string) {
        this.message = string;
        this.updateGUI();
    }

    public void updateGUI() {
        Runnable updateGui = new Runnable(){
            final LoginController login;
            final LoginState loginState;
            final String message;
            {
                this.login = LoginThread.this.login;
                this.loginState = LoginThread.this.loginState;
                this.message = LoginThread.this.message;
            }

            @Override
            public void run() {
                boolean wasVisible = this.login.progressBar.isVisible();
                this.login.progressBar.setVisible(this.loginState == LoginState.UPDATING_MOD || this.loginState == LoginState.LOADING_ASSETS);
                if (!wasVisible && this.login.progressBar.isVisible()) {
                    this.login.progressBar.setProgress(-1.0);
                }
                this.login.setStatus(this.message);
            }
        };
        if (Platform.isFxApplicationThread()) {
            updateGui.run();
        } else {
            Platform.runLater((Runnable)updateGui);
        }
    }

    public void stateChanged(final String fileName, final int progress) {
        try {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    LoginThread.this.login.stateChanged(fileName, progress);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private /* synthetic */ void lambda$run$0(CountDownLatch doneLatch) {
        if (this.auth instanceof YggdrasilAccount) {
            this.auth = new YggdrasilAccount(this.login.showAddAccountStage());
        }
        doneLatch.countDown();
    }
}

