/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher.assets;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.craftland.launcher.WorkingDirectory;
import org.craftland.launcher.assets.AssetIndex;
import org.craftland.launcher.assets.Downloadable;
import org.craftland.launcher.exception.MCNetworkException;
import org.craftland.util.UpdateUtils;

public class AssetDownloadable
extends Downloadable {
    private final String name;
    private final AssetIndex.AssetObject asset;
    private final String urlBase;
    private final File destination;
    private Downloadable.Status status = Downloadable.Status.DOWNLOADING;

    public AssetDownloadable(Proxy proxy, String name, AssetIndex.AssetObject asset, String urlBase, File destination) throws MalformedURLException {
        super(proxy, new URL(urlBase + AssetDownloadable.createPathFromHash(asset.getHash())), new File(destination, AssetDownloadable.createPathFromHash(asset.getHash())), false);
        this.name = name;
        this.asset = asset;
        this.urlBase = urlBase;
        this.destination = destination;
        File localAsset = this.getTarget();
        File localCompressed = this.asset.hasCompressedAlternative() ? new File(this.destination, AssetDownloadable.createPathFromHash(this.asset.getCompressedHash())) : null;
        this.status = Downloadable.Status.DOWNLOADING;
        if (localAsset.isFile() && FileUtils.sizeOf((File)localAsset) == this.asset.getSize()) {
            this.status = Downloadable.Status.UPTODATE;
        } else if (localCompressed != null && localCompressed.isFile() && AssetDownloadable.getDigest(localCompressed, "SHA", 40).equalsIgnoreCase(this.asset.getCompressedHash())) {
            this.status = Downloadable.Status.EXTRACTING;
        }
    }

    protected static String createPathFromHash(String hash) {
        return hash.substring(0, 2) + "/" + hash;
    }

    @Override
    public boolean tryCopyFromVanilla(File vanillaDir) {
        if (this.status == Downloadable.Status.DOWNLOADING) {
            File localCompressed;
            File assets = new File(WorkingDirectory.getVanillaWorkingDirectory(), "assets");
            File objectsFolder = new File(assets, "objects");
            File localVanilaTargetFile = new File(objectsFolder, AssetDownloadable.createPathFromHash(this.asset.getHash()));
            File localVanilaCompressed = this.asset.hasCompressedAlternative() ? new File(objectsFolder, AssetDownloadable.createPathFromHash(this.asset.getCompressedHash())) : null;
            File localAsset = this.getTarget();
            File file = localCompressed = this.asset.hasCompressedAlternative() ? new File(this.destination, AssetDownloadable.createPathFromHash(this.asset.getCompressedHash())) : null;
            if (localVanilaTargetFile.isFile() && FileUtils.sizeOf((File)localVanilaTargetFile) == this.asset.getSize()) {
                try {
                    UpdateUtils.copyFile(localVanilaTargetFile, localAsset);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                return true;
            }
            if (localVanilaCompressed != null && localVanilaCompressed.isFile() && AssetDownloadable.getDigest(localVanilaCompressed, "SHA", 40).equalsIgnoreCase(this.asset.getCompressedHash())) {
                try {
                    UpdateUtils.copyFile(localVanilaCompressed, localCompressed);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public String download() throws IOException, MCNetworkException {
        int status;
        HttpURLConnection connection1;
        ++this.numAttempts;
        File localAsset = this.getTarget();
        File localCompressed = this.asset.hasCompressedAlternative() ? new File(this.destination, AssetDownloadable.createPathFromHash(this.asset.getCompressedHash())) : null;
        URL remoteAsset = this.getUrl();
        URL remoteCompressed = this.asset.hasCompressedAlternative() ? new URL(this.urlBase + AssetDownloadable.createPathFromHash(this.asset.getCompressedHash())) : null;
        this.ensureFileWritable(localAsset);
        if (localCompressed != null) {
            this.ensureFileWritable(localCompressed);
        }
        if (localAsset.isFile()) {
            if (FileUtils.sizeOf((File)localAsset) == this.asset.getSize()) {
                return "Have local file and it's the same size; assuming it's okay!";
            }
            System.err.printf("Had local file but it was the wrong size... had %d but expected %d\n", FileUtils.sizeOf((File)localAsset), this.asset.getSize());
            FileUtils.deleteQuietly((File)localAsset);
            this.status = Downloadable.Status.DOWNLOADING;
        }
        if (localCompressed != null && localCompressed.isFile()) {
            String connection = AssetDownloadable.getDigest(localCompressed, "SHA", 40);
            if (connection.equalsIgnoreCase(this.asset.getCompressedHash())) {
                return this.decompressAsset(localAsset, localCompressed);
            }
            System.err.printf("Had local compressed but it was the wrong hash... expected %d but had %d\n", this.asset.getCompressedHash(), connection);
            FileUtils.deleteQuietly((File)localCompressed);
        }
        if (remoteCompressed != null && localCompressed != null) {
            int status2;
            HttpURLConnection connection12;
            try {
                connection12 = this.makeConnection(remoteCompressed);
                status2 = connection12.getResponseCode();
            }
            catch (IOException e) {
                throw new MCNetworkException(e);
            }
            if (status2 / 100 == 2) {
                this.updateExpectedSize(connection12);
                InputStream inputStream = connection12.getInputStream();
                FileOutputStream outputStream = new FileOutputStream(localCompressed);
                String hash = AssetDownloadable.copyAndDigest(inputStream, outputStream, "SHA", 40);
                if (hash.equalsIgnoreCase(this.asset.getCompressedHash())) {
                    return this.decompressAsset(localAsset, localCompressed);
                }
                FileUtils.deleteQuietly((File)localCompressed);
                throw new RuntimeException(String.format("Hash did not match downloaded compressed asset (Expected %s, downloaded %s)", this.asset.getCompressedHash(), hash));
            }
            throw new MCNetworkException("Server responded with " + status2);
        }
        try {
            connection1 = this.makeConnection(remoteAsset);
            status = connection1.getResponseCode();
        }
        catch (IOException e) {
            throw new MCNetworkException(e);
        }
        if (status / 100 == 2) {
            this.updateExpectedSize(connection1);
            InputStream inputStream = connection1.getInputStream();
            FileOutputStream outputStream = new FileOutputStream(localAsset);
            String hash = AssetDownloadable.copyAndDigest(inputStream, outputStream, "SHA", 40);
            if (hash.equalsIgnoreCase(this.asset.getHash())) {
                return "Downloaded asset and hash matched successfully";
            }
            FileUtils.deleteQuietly((File)localAsset);
            throw new RuntimeException(String.format("Hash did not match downloaded asset (Expected %s, downloaded %s)", this.asset.getHash(), hash));
        }
        throw new MCNetworkException("Server responded with " + status);
    }

    @Override
    public Downloadable.Status getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String decompressAsset(File localAsset, File localCompressed) throws IOException {
        String hash;
        FileOutputStream outputStream = FileUtils.openOutputStream((File)localAsset);
        GZIPInputStream inputStream = new GZIPInputStream(FileUtils.openInputStream((File)localCompressed));
        try {
            hash = AssetDownloadable.copyAndDigest(inputStream, outputStream, "SHA", 40);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        if (hash.equalsIgnoreCase(this.asset.getHash())) {
            return "Had local compressed asset, unpacked successfully and hash matched";
        }
        FileUtils.deleteQuietly((File)localAsset);
        throw new RuntimeException("Had local compressed asset but unpacked hash did not match (expected " + this.asset.getHash() + " but had " + hash + ")");
    }

    @Override
    public String getOut() {
        return this.name;
    }
}

