/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher.download;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.craftland.launcher.LoginThread;
import org.craftland.launcher.WorkingDirectory;

public class Download
implements Runnable {
    private static final int BUFFER = 4096;
    private final URL url;
    private final String outPath;
    private String displayPath;
    private LoginThread listener;

    public Download(String url, String outPath) throws MalformedURLException {
        this.url = new URL(url);
        this.outPath = outPath;
        String fullPath = new File(outPath).getAbsolutePath();
        String workingDirPath = WorkingDirectory.getWorkingDirectory().getAbsolutePath();
        int pos2 = workingDirPath.length();
        if (pos2 < fullPath.length()) {
            this.displayPath = fullPath.substring(pos2);
            if (this.displayPath.charAt(0) == File.separatorChar && this.displayPath.length() > 1) {
                this.displayPath = this.displayPath.substring(1);
            }
        } else {
            this.displayPath = outPath;
        }
    }

    @Override
    public void run() {
        try {
            this.load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws Exception {
        InputStream stream = null;
        File outFile = new File(this.outPath);
        File parentDir = outFile.getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        if (outFile.exists()) {
            outFile.delete();
        }
        try {
            HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
            connection.setUseCaches(false);
            connection.setDefaultUseCaches(false);
            connection.setRequestProperty("Cache-Control", "no-store,max-age=0,no-cache");
            connection.setRequestProperty("Expires", "0");
            connection.setRequestProperty("Pragma", "no-cache");
            connection.setConnectTimeout(20000);
            connection.setReadTimeout(30000);
            connection.connect();
            if (connection.getResponseCode() / 100 != 2) {
                stream = connection.getErrorStream();
                if (stream != null) {
                    String s;
                    BufferedReader read = new BufferedReader(new InputStreamReader(stream));
                    Object err = "";
                    while ((s = read.readLine()) != null) {
                        err = (String)err + s;
                    }
                    throw new IOException("Failed loading " + this.outPath + ":\n" + (String)err);
                }
                throw new IOException("Failed to load " + this.url + ":\nResponse code " + connection.getResponseCode());
            }
            int fileSize = connection.getContentLength();
            try (FileOutputStream fos = null;){
                int length;
                if (this.listener != null) {
                    this.listener.stateChanged(this.outPath, 0);
                }
                stream = connection.getInputStream();
                fos = new FileOutputStream(this.outPath);
                BufferedOutputStream out = new BufferedOutputStream(fos, 32768);
                byte[] buffer = new byte[4096];
                int readBytes = 0;
                int l = 0;
                while ((length = stream.read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, length);
                    readBytes += length;
                    if (fileSize <= 0 || this.listener == null || ++l % 64 != 0) continue;
                    this.listener.stateChanged(this.outPath, Math.round((float)readBytes / (float)fileSize * 100.0f));
                }
                stream.close();
                ((OutputStream)out).flush();
                if (this.listener != null) {
                    this.listener.stateChanged(this.outPath, 100);
                }
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public void setListener(LoginThread listener) {
        this.listener = listener;
    }
}

