/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher.download;

import java.io.File;
import java.net.MalformedURLException;
import org.craftland.launcher.LauncherSettings;
import org.craftland.launcher.LoginThread;
import org.craftland.launcher.MinecraftOptionsHelper;
import org.craftland.launcher.WorkingDirectory;
import org.craftland.launcher.download.Download;

public class ExtraDownload {
    String id;
    String name;
    String desc;
    String url;
    int version;
    String fileName;

    public ExtraDownload(String id, String name, String desc, String url, String fileName, String version) {
        this.id = id;
        this.name = name;
        this.desc = desc;
        this.url = url;
        this.fileName = fileName;
        this.version = Integer.parseInt(version);
    }

    public String getDescription() {
        return this.desc;
    }

    public String getName() {
        return this.name;
    }

    public String getURL() {
        return this.url;
    }

    public int getVersion() {
        return this.version;
    }

    public File getOutFile() {
        if (this.id.startsWith("resourcepack_")) {
            return new File(WorkingDirectory.getWorkingDirectory(), "resourcepacks" + File.separator + this.fileName);
        }
        return new File(WorkingDirectory.getWorkingDirectory(), this.fileName);
    }

    public boolean install(boolean isUpdate, LoginThread loginThread) throws MalformedURLException {
        File outFile = this.getOutFile();
        if (!outFile.getParentFile().exists()) {
            outFile.getParentFile().mkdirs();
        }
        Download download = new Download(this.getURL(), outFile.getAbsolutePath());
        download.setListener(loginThread);
        download.run();
        LauncherSettings.getInstance().setInteger("version_" + this.id, this.getVersion());
        if (!isUpdate && this.id.startsWith("resourcepack_")) {
            MinecraftOptionsHelper.setActiveTexturePack(this.getFileName());
        }
        return true;
    }

    private String getFileName() {
        return this.fileName;
    }

    public boolean remove() {
        File outFile = this.getOutFile();
        if (outFile.exists()) {
            outFile.delete();
        }
        LauncherSettings.getInstance().setInteger("version_" + this.id, 0);
        return true;
    }

    public boolean isInstalled() {
        return this.getLocalVersion() > 0;
    }

    public int getLocalVersion() {
        return LauncherSettings.getInstance().getInt("version_" + this.id);
    }

    public boolean hasUpdate() {
        return this.getLocalVersion() < this.version;
    }

    public String getID() {
        return this.id;
    }
}

