/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher.guifx;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Accordion;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Tab;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.imageio.ImageIO;
import org.craftland.launcher.LauncherSettings;
import org.craftland.launcher.LoginState;
import org.craftland.launcher.LoginThread;
import org.craftland.launcher.accounts.Account;
import org.craftland.launcher.accounts.Accounts;
import org.craftland.launcher.download.ExtraDownload;
import org.craftland.launcher.guifx.AddAccountController;
import org.craftland.launcher.guifx.DownloadController;
import org.craftland.launcher.guifx.DownloadEntry;
import org.craftland.launcher.guifx.NewsController;
import org.craftland.launcher.guifx.SettingsController;
import org.craftland.launcher.guifx.TextDialog;
import org.craftland.launcher.microsoft.MicrosoftAuthWindow;
import org.craftland.launcher.mojang.YggdrasilResponseAuth;
import org.craftland.launcher.updater.GameUpdater;
import org.craftland.util.ImageLoader;
import org.craftland.util.JVMHelper;
import org.craftland.util.Memory;
import org.craftland.util.RenderCharacter;

public class LoginController
implements Initializable {
    private final Image steveHead = new Image(this.getClass().getResource("/img/stevehead.png").toExternalForm());
    public BorderPane loginPane;
    public Label labelStatus;
    private final ChangeListener<String> messageListener = new ChangeListener<String>(){

        public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
            LoginController.this.setStatus(newValue);
        }
    };
    public Accordion accordionNews;
    public Tab tabNews;
    public Tab tabDownload;
    public Tab tabSettings;
    public Tab tabAccounts;
    public Button buttonLogin;
    public HBox accountsPane;
    public VBox vboxAccount1;
    public ImageView imageAccount1;
    public Button loginAccount1;
    public VBox vboxAccount2;
    public ImageView imageAccount2;
    public Button loginAccount2;
    public StackPane paneProgress;
    public ProgressBar progressBar;
    private final ChangeListener<Number> progressListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            LoginController.this.setProgress(newValue.doubleValue());
        }
    };
    public Label progressText;
    public Accordion accordionDownload;
    public ComboBox<Account> comboBoxUsername;
    public ListView<Account> listviewAccounts;
    public VBox vboxAccountControl;
    public ImageView accountImageHead;
    public StackPane paneStatus;
    public Text labelUsernameAccount;
    public Button btnRemoveAccount;
    public Button btnAddAccount;
    public Button btnDebug;
    public Button btnAddMicrosoftAccount;
    private DownloadEntry currentDownload;
    private BufferedImage imgSteve = null;
    private Map<String, BufferedImage> skinMap = new ConcurrentHashMap<String, BufferedImage>();
    private LoginThread loginThread;
    private Vector<DownloadEntry> outdatedDownloads = new Vector();
    private int fails;
    private LoginState state;
    private SettingsController settingsController;
    private TextDialog dialog;

    public void setStatus(String s) {
        this.labelStatus.setVisible(true);
        this.labelStatus.setText(s);
    }

    public void setProgressText(String s) {
        this.paneProgress.setVisible(true);
        this.progressText.setVisible(true);
        this.progressText.setText(s);
    }

    public void setProgress(double progress) {
        this.paneProgress.setVisible(true);
        this.progressBar.setVisible(true);
        this.progressBar.setProgress(progress);
    }

    public void initialize(URL location, ResourceBundle resources) {
        String nname2;
        this.buttonLogin.setDisable(true);
        this.labelStatus.visibleProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                LoginController.this.paneStatus.setVisible(newValue.booleanValue());
            }
        });
        this.labelStatus.setVisible(false);
        this.tabNews.setGraphic((Node)new ImageView(new Image(this.getClass().getResource("/img/newspaper.png").toExternalForm(), 16.0, 16.0, true, true)));
        this.tabDownload.setGraphic((Node)new ImageView(new Image(this.getClass().getResource("/img/arrow_down.png").toExternalForm(), 16.0, 16.0, true, true)));
        this.tabSettings.setGraphic((Node)new ImageView(new Image(this.getClass().getResource("/img/wrench.png").toExternalForm(), 16.0, 16.0, true, true)));
        this.tabAccounts.setGraphic((Node)new ImageView(new Image(this.getClass().getResource("/img/user.png").toExternalForm(), 16.0, 16.0, true, true)));
        String name1 = Accounts.getInstance().getAccountName(0);
        String name2 = Accounts.getInstance().getAccountName(1);
        String nname1 = Accounts.getInstance().getAccountName(0);
        boolean changedAccounts = false;
        if (nname1 == null && name1 != null || nname1 != null && name1 == null || name1 != null && !name1.equals(nname1)) {
            changedAccounts = true;
        }
        if ((nname2 = Accounts.getInstance().getAccountName(1)) == null && name2 != null || nname2 != null && name2 == null || name2 != null && !name2.equals(nname2)) {
            changedAccounts = true;
        }
        this.updateAccountLabels(changedAccounts);
        this.labelStatus.setVisible(false);
        this.comboBoxUsername.setItems(Accounts.getInstance().getAccounts());
        if (this.comboBoxUsername.getItems().size() > 0) {
            this.comboBoxUsername.getSelectionModel().select(0);
        }
        NewsController.load(this.accordionNews);
        this.outdatedDownloads.addAll(DownloadController.load(this, this.accordionDownload));
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("settings.fxml"));
        try {
            Node node = (Node)loader.load();
            SettingsController controller = (SettingsController)loader.getController();
            controller.initialize(this);
            this.settingsController = controller;
            this.tabSettings.setContent(node);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.listviewAccounts.setItems(Accounts.getInstance().getAccounts());
        this.listviewAccounts.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Account>(){

            public void changed(ObservableValue<? extends Account> observable, Account oldValue, Account newValue) {
                if (newValue != null) {
                    LoginController.this.accountImageHead.setImage(LoginController.this.steveHead);
                    try {
                        String url = "http://craftland.org/skins/uuid/" + newValue.getUserID() + "/head?size=32";
                        ImageLoader bgLoader = new ImageLoader(url){

                            @Override
                            public void done() {
                                BufferedImage img = this.image;
                                if (img != null) {
                                    Platform.runLater(() -> {
                                        WritableImage fximg = new WritableImage(img.getWidth(), img.getHeight());
                                        SwingFXUtils.toFXImage((BufferedImage)img, (WritableImage)fximg);
                                        LoginController.this.accountImageHead.setSmooth(false);
                                        LoginController.this.accountImageHead.setImage((Image)fximg);
                                    });
                                }
                            }
                        };
                        bgLoader.execute();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    LoginController.this.labelUsernameAccount.setText(newValue.getUsername());
                    LoginController.this.vboxAccountControl.setVisible(true);
                } else {
                    LoginController.this.vboxAccountControl.setVisible(false);
                }
            }
        });
        this.btnAddAccount.setGraphic((Node)new ImageView(new Image(this.getClass().getResource("/img/add.png").toExternalForm(), 16.0, 16.0, false, false)));
        this.btnAddMicrosoftAccount.setGraphic((Node)new ImageView(new Image(this.getClass().getResource("/img/microsoft.png").toExternalForm(), 16.0, 16.0, false, false)));
        this.btnRemoveAccount.setGraphic((Node)new ImageView(new Image(this.getClass().getResource("/img/delete.png").toExternalForm(), 16.0, 16.0, false, false)));
        Account auth1 = Accounts.getInstance().getModelItem(0);
        if (auth1 != null) {
            this.makePreview();
        }
        this.buttonLogin.setDisable(false);
    }

    public void updateAccountLabels(boolean renderSkins) {
        if (renderSkins) {
            this.makePreview();
        }
    }

    private BufferedImage buildSteve() {
        if (this.imgSteve == null) {
            try {
                this.imgSteve = RenderCharacter.drawCharacter(ImageIO.read(this.getClass().getResourceAsStream("/img/steve.png")));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.imgSteve;
    }

    private void makePreview() {
        Account[] auth = new Account[]{Accounts.getInstance().getModelItem(0), Accounts.getInstance().getModelItem(1)};
        boolean[] wasVisible = new boolean[]{this.vboxAccount1.isVisible(), this.vboxAccount2.isVisible()};
        VBox[] vboxes = new VBox[]{this.vboxAccount1, this.vboxAccount2};
        final ImageView[] label = new ImageView[]{this.imageAccount1, this.imageAccount2};
        Button[] button = new Button[]{this.loginAccount1, this.loginAccount2};
        for (int i = 0; i < 2; ++i) {
            vboxes[i].setVisible(auth[i] != null);
            if (auth[i] == null) continue;
            button[i].setText(auth[i].getUsername());
            button[i].setTooltip(new Tooltip("Login as " + auth[i].getUsername()));
            if (!wasVisible[i]) {
                BufferedImage img1 = this.buildSteve();
                WritableImage img = new WritableImage(img1.getWidth(), img1.getHeight());
                SwingFXUtils.toFXImage((BufferedImage)img1, (WritableImage)img);
                label[i].setImage((Image)img);
            }
            String URL2 = "http://craftland.org/skins/uuid/" + auth[i].getUserID() + "?rescale=true";
            BufferedImage imgPr = this.skinMap.get(URL2);
            final int idx = i;
            if (imgPr != null) {
                WritableImage img = new WritableImage(imgPr.getWidth(), imgPr.getHeight());
                SwingFXUtils.toFXImage((BufferedImage)imgPr, (WritableImage)img);
                label[idx].setImage((Image)img);
                continue;
            }
            ImageLoader bgLoader = new ImageLoader(URL2){

                @Override
                public void done() {
                    try {
                        if (this.image == null) {
                            label[idx].setVisible(true);
                            BufferedImage steve = LoginController.this.buildSteve();
                            WritableImage img = new WritableImage(steve.getWidth(), steve.getHeight());
                            SwingFXUtils.toFXImage((BufferedImage)steve, (WritableImage)img);
                            label[idx].setImage((Image)img);
                        } else {
                            BufferedImage img = RenderCharacter.drawCharacter(this.image);
                            LoginController.this.skinMap.put(this.URL, img);
                            label[idx].setVisible(true);
                            WritableImage fximg = new WritableImage(img.getWidth(), img.getHeight());
                            SwingFXUtils.toFXImage((BufferedImage)img, (WritableImage)fximg);
                            label[idx].setImage((Image)fximg);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            bgLoader.setTimeout(30000);
            bgLoader.execute();
        }
    }

    public void login(ActionEvent actionEvent) {
        this.login(true);
    }

    public void update(DownloadEntry downloadEntry) throws InterruptedException {
        ExtraDownload download = downloadEntry.getDownload();
        if (!download.hasUpdate() && download.isInstalled()) {
            downloadEntry.runUninstall();
            String downloadName = download.getName();
            this.setStatus(downloadName + " removed!");
        } else {
            this.currentDownload = downloadEntry;
            this.login(false);
        }
    }

    private void login(boolean startGame) {
        boolean b;
        if (this.loginThread != null) {
            Alert alert = new Alert(Alert.AlertType.INFORMATION, "Game is already running", new ButtonType[0]);
            alert.setHeaderText("Cannot start game");
            alert.showAndWait();
            return;
        }
        int memory = Memory.getInMB(LauncherSettings.getInstance().getInt("memory", 0));
        if (memory > 0 && !(b = JVMHelper.checkMemorySetting(memory))) {
            this.setStatus("Cannot start java with " + memory + "MB of memory!");
            this.selectSettings();
            return;
        }
        boolean keepOpen = LauncherSettings.getInstance().getBoolean("keepOpen");
        this.loginThread = new LoginThread(this);
        this.loginThread.setStartGame(startGame);
        this.loginThread.setKeepOpen(keepOpen);
        String jvmArgs = LauncherSettings.getInstance().getString("jvmargs");
        if (jvmArgs != null && jvmArgs.length() > 0) {
            this.loginThread.setJvmArgs(jvmArgs);
        }
        this.loginThread.setMemory(memory > 0 ? memory : 0);
        Account auth = (Account)this.comboBoxUsername.getSelectionModel().getSelectedItem();
        this.loginThread.setAuth(auth);
        this.loginThread.setSkipAuth(this.skipLogin());
        this.comboBoxUsername.setDisable(true);
        this.progressText.setVisible(true);
        this.btnDebug.setVisible(false);
        this.buttonLogin.setDisable(true);
        this.loginAccount1.setDisable(true);
        this.loginAccount2.setDisable(true);
        boolean logConsole = LauncherSettings.getInstance().getBoolean("logConsole");
        if (logConsole) {
            this.dialog = new TextDialog(this, "craftland.log", "Log");
        }
        this.loginThread.start();
    }

    private boolean skipLogin() {
        return false;
    }

    private void selectSettings() {
        this.tabSettings.getTabPane().getSelectionModel().select((Object)this.tabSettings);
        this.settingsController.memoryCombo.requestFocus();
    }

    public DownloadEntry getCurrentDownload() {
        return this.currentDownload;
    }

    public Thread getLoginThread() {
        return this.loginThread;
    }

    public void setLoginThread(LoginThread loginThread) {
        this.loginThread = loginThread;
    }

    public void updateSettings() {
        this.settingsController.updateSettings();
    }

    public Vector<DownloadEntry> getOutdatedDownloads() {
        return this.outdatedDownloads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLoginThreadEnded(LoginState loginState, String message, Throwable lastException, boolean forceUpdate) {
        boolean wasInstallDownload = this.getCurrentDownload() != null;
        try {
            if (forceUpdate) {
                ++this.fails;
                if (this.fails <= 2) {
                    GameUpdater.resetStateSoft();
                } else {
                    GameUpdater.resetState();
                }
            }
            if (lastException != null) {
                this.setStatus(lastException.getMessage());
                String m = this.state == LoginState.UPDATEFAILED ? "Update failed" : "Exception occured";
                LoginController.showErrorDialog(m, lastException);
            } else {
                this.setStatus(message);
            }
            this.btnDebug.setVisible(lastException != null);
            this.comboBoxUsername.setDisable(false);
            this.buttonLogin.setDisable(false);
            this.loginAccount1.setDisable(false);
            this.loginAccount2.setDisable(false);
            this.progressBar.setVisible(false);
            this.progressText.setText("");
            this.progressBar.setProgress(0.0);
            if (this.buttonLogin.getText().equals("Cancel")) {
                this.buttonLogin.setText("Login");
            }
            if (this.getCurrentDownload() != null) {
                this.currentDownload.onLoginThreadEnded();
            }
            this.currentDownload = null;
        }
        finally {
            if (wasInstallDownload || this.state != LoginState.LOGINDONE) {
                this.loginThread = null;
            }
        }
    }

    public static void showErrorDialog(String m, Throwable lastException) {
        Alert dialog = new Alert(Alert.AlertType.ERROR, m, new ButtonType[0]);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        lastException.printStackTrace(pw);
        String exceptionText = sw.toString();
        Label label = new Label("The exception stacktrace was:");
        TextArea textArea = new TextArea(exceptionText);
        textArea.setEditable(false);
        textArea.setWrapText(true);
        textArea.setMaxWidth(Double.MAX_VALUE);
        textArea.setMaxHeight(Double.MAX_VALUE);
        GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane expContent = new GridPane();
        expContent.setMaxWidth(Double.MAX_VALUE);
        expContent.add((Node)label, 0, 0);
        expContent.add((Node)textArea, 0, 1);
        dialog.getDialogPane().setExpandableContent((Node)expContent);
        dialog.showAndWait();
    }

    public void stateChanged(String fileName, int progress) {
        this.setProgressText(fileName);
        this.setProgress((double)progress / 100.0);
    }

    public void loginAccount1(ActionEvent actionEvent) {
        Account auth = Accounts.getInstance().getModelItem(0);
        if (auth != null) {
            this.comboBoxUsername.getSelectionModel().select((Object)auth);
            this.login(true);
        }
    }

    public void loginAccount2(ActionEvent actionEvent) {
        Account auth = Accounts.getInstance().getModelItem(1);
        if (auth != null) {
            this.comboBoxUsername.getSelectionModel().select((Object)auth);
            this.login(true);
        }
    }

    public void addAccount(ActionEvent actionEvent) {
        this.showAddAccountStage();
    }

    public YggdrasilResponseAuth showAddAccountStage() {
        Stage stage = new Stage();
        Window parentWindow = this.loginPane.getScene().getWindow();
        stage.initOwner(parentWindow);
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setTitle("Login");
        stage.getIcons().addAll((Collection)((Stage)parentWindow).getIcons());
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("addaccount.fxml"));
        Parent load = null;
        try {
            load = (Parent)loader.load();
            AddAccountController controller = (AddAccountController)loader.getController();
            controller.init(this);
            stage.setScene(new Scene(load));
            stage.showAndWait();
            Accounts.getInstance().write();
            this.updateAccountLabels(true);
            return controller.getAuth();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void removeAccount(ActionEvent actionEvent) {
        Account auth = (Account)this.listviewAccounts.getSelectionModel().getSelectedItem();
        if (auth != null) {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Are you sure you want to remove this account?", new ButtonType[0]);
            alert.setHeaderText("Remove account");
            alert.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.YES, ButtonType.CANCEL});
            Optional result = alert.showAndWait();
            if (result.isPresent() && result.get() == ButtonType.YES) {
                Accounts.getInstance().removeID(auth.getUserID());
                this.updateAccountLabels(true);
            }
        }
    }

    public void debugException(ActionEvent actionEvent) {
        if (this.loginThread != null && this.loginThread.lastException != null) {
            LoginController.showErrorDialog("Debug", this.loginThread.lastException);
        }
    }

    public void addMsAccount(ActionEvent actionEvent) {
        MicrosoftAuthWindow msa = new MicrosoftAuthWindow();
        msa.setCallback(() -> {
            if (msa.getAccount() != null) {
                Accounts.getInstance().putOrUpdate(msa.getAccount());
            }
        });
        msa.initialize(null, null);
    }

    public TextDialog getLogWindow() {
        return this.dialog;
    }
}

