/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher.guifx;

import java.io.File;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Scanner;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.craftland.launcher.GameProcess;
import org.craftland.launcher.Launcher;
import org.craftland.launcher.LauncherSettings;
import org.craftland.launcher.WorkingDirectory;
import org.craftland.launcher.guifx.LoginController;
import org.craftland.launcher.updater.GameUpdater;
import org.craftland.util.DesktopUtils;
import org.craftland.util.JVMHelper;
import org.craftland.util.Memory;

public class SettingsController {
    public VBox vboxSettings;
    public ComboBox<String> memoryCombo;
    public TextField additionalArgs;
    public Hyperlink hyperlinkWorkingDir;
    public Button btnForceUpdate;
    public Button btnResetConfig;
    public Button btnShowLogs;
    private CheckBox ipv4Box;
    private CheckBox videorecorderCheckBox;
    private LoginController login;

    public void initialize(LoginController login) {
        this.login = login;
        this.addBool("Keep launcher open", "keepOpen", "Keeps launcher opened after game starts", false);
        this.addBool("Open logging console", "logConsole", "Opens a new window showing the log output of the running game", false);
        this.addBool("Start fullscreen", "fullscreen", null, false);
        this.addBool("Save window position and size", "restorewindow", null, false);
        this.addBool("Force High-performance GPU selection", "intel_nvidia_gpu_fix", "(i.e. Enable nVidia GPU instead of Intel HD graphics)", false);
        this.addBool("Use FrameBuffer Objects", "useFBO", "FrameBuffer objects speed up texture updates and allow GUI effects", true);
        this.addBool("Animate GUI", "useGUIAnimations", "Renders GUI effects when opening inventory/switching screens", true);
        this.addBool("Enable controller input", "controllerInput", "Use gamepads and controllers as input device", false);
        this.videorecorderCheckBox = this.addBool("Enable videorecorder", "videorecorder", "Enables the ingame video recording", false);
        this.addBool("Enable BASS library", "basslibrary", "Needed by musicplayer and jukebox radio", true);
        this.addBool("Enable debug mode", "debugmode", "Enables debug logging and ingame F4 menu", false);
        this.ipv4Box = this.addBool("Prefer IPv4 (IPv6 fix)", null, "Only use this if you have login problems", false);
        this.ipv4Box.setSelected(GameProcess.preferIPV4);
        File mcUpdateFolder = new File(WorkingDirectory.getWorkingDirectory(), "updateFolder");
        boolean has = new File(mcUpdateFolder, "xuggler.jar").exists();
        if (!has) {
            this.videorecorderCheckBox.setSelected(false);
        }
        this.videorecorderCheckBox.setDisable(!has);
        this.memoryCombo.getItems().addAll((Object[])new String[]{"default", "800 MB", "1 GB"});
        if (!Launcher.isWindows || !Launcher.is32BitJVM) {
            this.memoryCombo.getItems().addAll((Object[])new String[]{"2 GB", "4 GB", "6 GB", "8 GB", "12 GB", "16 GB"});
        }
        this.memoryCombo.setTooltip(new Tooltip("Recommended: 2GB or more"));
        this.memoryCombo.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                LauncherSettings.getInstance().setInteger("memory", SettingsController.this.memoryCombo.getSelectionModel().getSelectedIndex());
            }
        });
        this.additionalArgs.setText(LauncherSettings.getInstance().getString("jvmargs", ""));
        int idx = LauncherSettings.getInstance().getInt("memory", 0);
        if (idx >= this.memoryCombo.getItems().size()) {
            idx = this.memoryCombo.getItems().size() - 1;
        }
        if (idx < 0) {
            idx = 0;
        }
        this.memoryCombo.getSelectionModel().select(idx);
        final File workingDir = WorkingDirectory.getWorkingDirectory();
        this.hyperlinkWorkingDir.setText(workingDir.getAbsolutePath());
        this.hyperlinkWorkingDir.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DesktopUtils.open(workingDir.toURI());
            }
        });
        this.additionalArgs.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                LauncherSettings.getInstance().setString("jvmargs", SettingsController.this.additionalArgs.getText().trim());
            }
        });
        this.ipv4Box.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                GameProcess.preferIPV4 = SettingsController.this.ipv4Box.isSelected();
            }
        });
        this.btnForceUpdate.setGraphic((Node)new ImageView(new Image(this.getClass().getResource("/img/arrow_refresh.png").toExternalForm())));
        this.btnResetConfig.setGraphic((Node)new ImageView(new Image(this.getClass().getResource("/img/cog_delete.png").toExternalForm())));
        this.btnShowLogs.setGraphic((Node)new ImageView(new Image(this.getClass().getResource("/img/page_white_text.png").toExternalForm())));
    }

    private CheckBox addBool(String description, final String optionName, String tooltip, boolean def) {
        final CheckBox box = new CheckBox(description);
        if (optionName != null) {
            box.setSelected(LauncherSettings.getInstance().getBoolean(optionName, def));
            box.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    LauncherSettings.getInstance().setBoolean(optionName, box.isSelected());
                }
            });
        }
        if (tooltip != null) {
            box.setTooltip(new Tooltip(tooltip));
        }
        this.vboxSettings.getChildren().add((Object)box);
        return box;
    }

    public void updateSettings() {
        File mcUpdateFolder = new File(WorkingDirectory.getWorkingDirectory(), "updateFolder");
        boolean has = new File(mcUpdateFolder, "xuggler.jar").exists();
        if (!has) {
            this.videorecorderCheckBox.setSelected(false);
        }
        this.videorecorderCheckBox.setDisable(!has);
    }

    public void forceUpdate(ActionEvent actionEvent) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Are you sure you want to delete the updateFolder? (May take a second or two)", new ButtonType[0]);
        alert.setHeaderText("Force update");
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.YES, ButtonType.CANCEL});
        Optional result = alert.showAndWait();
        if (result.isPresent() && result.get() == ButtonType.YES) {
            GameUpdater.resetState();
            this.login.setStatus("Forcing Minecraft & mod update");
        }
    }

    public void resetConfig(ActionEvent actionEvent) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Are you sure you want to reset the configuration", new ButtonType[0]);
        alert.setHeaderText("Reset configuration");
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.YES, ButtonType.CANCEL});
        Optional result = alert.showAndWait();
        if (result.isPresent() && result.get() == ButtonType.YES) {
            LinkedList<File> toDelete = new LinkedList<File>();
            toDelete.add(new File(WorkingDirectory.getWorkingDirectory(), "options.txt"));
            toDelete.add(new File(WorkingDirectory.getWorkingDirectory(), "optionsof.txt"));
            toDelete.add(new File(WorkingDirectory.getWorkingDirectory(), "config" + File.separator + "CraftLand.cfg"));
            toDelete.add(new File(WorkingDirectory.getWorkingDirectory(), "config" + File.separator + "ModLoader.cfg"));
            for (File f : toDelete) {
                if (!f.exists()) continue;
                f.delete();
            }
            this.login.setStatus("Reset config done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showLogFile(ActionEvent actionEvent) {
        Object logText = "";
        String title = "";
        try (Scanner scanner = null;){
            File f = new File(WorkingDirectory.getWorkingDirectory(), "craftland.log");
            scanner = new Scanner(f);
            while (scanner.hasNext()) {
                logText = (String)logText + scanner.nextLine() + "\n";
            }
            title = f.getAbsolutePath();
        }
        Alert dialog = new Alert(Alert.AlertType.INFORMATION, title, new ButtonType[0]);
        Label label = new Label("Log file:");
        TextArea textArea = new TextArea((String)logText);
        textArea.setEditable(false);
        textArea.setWrapText(true);
        textArea.setMaxWidth(Double.MAX_VALUE);
        textArea.setMaxHeight(Double.MAX_VALUE);
        GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane expContent = new GridPane();
        expContent.setMaxWidth(Double.MAX_VALUE);
        expContent.add((Node)label, 0, 0);
        expContent.add((Node)textArea, 0, 1);
        dialog.getDialogPane().setExpandableContent((Node)expContent);
        dialog.getDialogPane().setExpanded(true);
        dialog.showAndWait();
    }

    public void testMem(ActionEvent actionEvent) {
        int memory = Memory.getInMB(LauncherSettings.getInstance().getInt("memory", 0));
        if (memory > 0) {
            boolean b = JVMHelper.checkMemorySetting(memory);
            if (b) {
                Alert alert = new Alert(Alert.AlertType.INFORMATION, "Successfully started java with " + memory + "MB of memory!", new ButtonType[0]);
                alert.setHeaderText("Success");
                alert.showAndWait();
            } else {
                Alert alert = new Alert(Alert.AlertType.INFORMATION, "Cannot start java with " + memory + "MB of memory!", new ButtonType[0]);
                alert.setHeaderText("Error");
                alert.showAndWait();
            }
        }
    }
}

