/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher.microsoft;

import java.util.concurrent.Semaphore;
import org.craftland.launcher.accounts.Account;
import org.craftland.launcher.microsoft.MicrosoftAuthProcess;

public class MicrosoftAccount
extends Account {
    protected String authCode;
    protected String refreshToken;

    public String getAuthCode() {
        return this.authCode;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    @Override
    public void refreshToken() {
        try {
            MicrosoftAuthProcess authProcess = new MicrosoftAuthProcess();
            Semaphore semaphore = new Semaphore(1);
            authProcess.setCallback(semaphore::release);
            semaphore.acquire();
            authProcess.refreshToken(this.refreshToken);
            semaphore.acquire();
            this.update(authProcess.getAccount());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void update(MicrosoftAccount account) {
        this.setUserId(account.id);
        this.setUsername(account.username);
        this.setValid(account.valid);
        this.setAccessToken(account.accessToken);
        this.setRefreshToken(account.refreshToken);
        this.setAuthCode(account.authCode);
    }
}

