/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher.mojang;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.IOException;
import org.craftland.launcher.exception.BadLoginException;
import org.craftland.launcher.exception.InvalidTokenException;
import org.craftland.launcher.exception.MCNetworkException;
import org.craftland.launcher.exception.MigratedMojangAccountException;
import org.craftland.launcher.mojang.YggdrasilResponse;
import org.craftland.launcher.mojang.YggdrasilResponseAuth;
import org.craftland.launcher.mojang.YggdrasilResponseError;
import org.craftland.util.HTTPPost;
import org.craftland.util.HTTPReply;

public class Yggdrasil {
    static final Gson gson = new GsonBuilder().create();
    public static final String URL_CONNECTION = "https://authserver.mojang.com";
    public static final String CLIENT_TOKEN = "craftlandlauncher";

    public static YggdrasilResponse doAuth(String username, String password, int timeOut) throws IOException, MCNetworkException {
        String request = Yggdrasil.buildAuthRequest(username, password, CLIENT_TOKEN);
        HTTPReply result = HTTPPost.excutePost("https://authserver.mojang.com/authenticate", request, "application/json", timeOut);
        JsonParser parser = new JsonParser();
        JsonElement jsonElement = parser.parse(result.result);
        if (jsonElement.isJsonObject()) {
            JsonObject responseObj = (JsonObject)jsonElement;
            if (result.code == 200 && responseObj != null) {
                return new YggdrasilResponseAuth(responseObj);
            }
            if (responseObj != null) {
                return new YggdrasilResponseError(responseObj);
            }
        }
        throw new MCNetworkException(result.code + " Bad Reply, " + result.result);
    }

    public static YggdrasilResponseAuth doLogin(String user, String pass, int timeOut) throws MCNetworkException, MigratedMojangAccountException, BadLoginException {
        try {
            YggdrasilResponse response = Yggdrasil.doAuth(user, pass, timeOut);
            if (response instanceof YggdrasilResponseError) {
                YggdrasilResponseError error = (YggdrasilResponseError)response;
                if ("UserMigratedException".equals(error.getCause())) {
                    throw new MigratedMojangAccountException();
                }
                throw new BadLoginException(error.getErrorMessage());
            }
            if (response instanceof YggdrasilResponseAuth) {
                return (YggdrasilResponseAuth)response;
            }
        }
        catch (IOException e) {
            throw new MCNetworkException(e);
        }
        catch (IllegalStateException e) {
            throw new MCNetworkException(e);
        }
        catch (JsonParseException e) {
            throw new MCNetworkException(e);
        }
        throw new BadLoginException("Login failed");
    }

    public static YggdrasilResponseAuth doRefresh(String user, int timeOut) throws Exception {
        try {
            YggdrasilResponse response = Yggdrasil._doRefresh(user, timeOut);
            if (response instanceof YggdrasilResponseError) {
                YggdrasilResponseError error = (YggdrasilResponseError)response;
                if ("UserMigratedException".equals(error.getCause())) {
                    throw new MigratedMojangAccountException();
                }
                throw new InvalidTokenException(error.getErrorMessage());
            }
            if (response instanceof YggdrasilResponseAuth) {
                return (YggdrasilResponseAuth)response;
            }
        }
        catch (IOException e) {
            throw new MCNetworkException(e);
        }
        catch (IllegalStateException e) {
            throw new MCNetworkException(e);
        }
        catch (JsonParseException e) {
            throw new MCNetworkException(e);
        }
        throw new BadLoginException("Login failed");
    }

    private static YggdrasilResponse _doRefresh(String accessToken, int timeOut) throws Exception {
        String request = Yggdrasil.buildRefreshRequest(accessToken, CLIENT_TOKEN);
        HTTPReply result = HTTPPost.excutePost("https://authserver.mojang.com/refresh", request, "application/json", timeOut);
        JsonParser parser = new JsonParser();
        JsonElement jsonElement = parser.parse(result.result);
        try {
            if (jsonElement.isJsonObject()) {
                JsonObject responseObj = (JsonObject)jsonElement;
                if (result.code == 200 && responseObj.has("accessToken")) {
                    return new YggdrasilResponseAuth(responseObj);
                }
                return new YggdrasilResponseError(responseObj);
            }
        }
        catch (Exception e) {
            System.err.println("While handling " + result.result);
            e.printStackTrace();
        }
        throw new MCNetworkException(result.code + " Bad Reply, " + result.result);
    }

    public static boolean _doValidate(String accessToken, int i) throws IOException, MCNetworkException {
        String request = Yggdrasil.buildValidate(accessToken, CLIENT_TOKEN);
        HTTPReply result = HTTPPost.excutePost("https://authserver.mojang.com/validate", request, "application/json", i);
        return result.result.isEmpty() && (result.code == 200 || result.code == 204 || result.code == 202);
    }

    public static String buildAuthRequest(String username, String password, String clientToken) {
        JsonObject root = new JsonObject();
        JsonObject agent = new JsonObject();
        agent.addProperty("name", "Minecraft");
        agent.addProperty("version", (Number)1);
        root.add("agent", (JsonElement)agent);
        root.addProperty("username", username);
        root.addProperty("password", password);
        root.addProperty("clientToken", clientToken);
        String ret = gson.toJson((JsonElement)root);
        return ret;
    }

    public static String buildRefreshRequest(String accessToken, String clientToken) {
        JsonObject root = new JsonObject();
        root.addProperty("accessToken", accessToken);
        root.addProperty("clientToken", clientToken);
        String ret = gson.toJson((JsonElement)root);
        return ret;
    }

    public static String buildValidate(String accessToken, String clientToken) {
        JsonObject root = new JsonObject();
        root.addProperty("accessToken", accessToken);
        String ret = gson.toJson((JsonElement)root);
        return ret;
    }
}

