/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher.loader;

import java.io.File;

public class PlatformUtils {
    private static boolean portable;
    private static File launcherDir;
    private static File workDir;

    public static File getLauncherDirectory() {
        if (launcherDir == null) {
            launcherDir = new File(".");
        }
        return launcherDir;
    }

    public static File getWorkingDirectory() {
        if (workDir == null) {
            workDir = PlatformUtils.getWorkingDirectory("craftland");
        }
        return workDir;
    }

    public static File getWorkingDirectory(String applicationName) {
        if (portable) {
            File fPortable = new File(applicationName);
            System.setProperty("craftlandPortable", fPortable.getAbsolutePath());
            return fPortable;
        }
        String userHome = System.getProperty("user.home", ".");
        File workingDirectory = switch (PlatformUtils.getPlatform()) {
            case OS.linux, OS.solaris -> new File(userHome, "." + applicationName + "/");
            case OS.windows -> {
                String applicationData = System.getenv("APPDATA");
                if (applicationData != null) {
                    yield new File(applicationData, "." + applicationName + "/");
                }
                yield new File(userHome, "." + applicationName + "/");
            }
            case OS.macos -> new File(userHome, "Library/Application Support/" + applicationName);
            default -> new File(userHome, applicationName + "/");
        };
        if (!workingDirectory.exists() && !workingDirectory.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + workingDirectory);
        }
        return workingDirectory;
    }

    public static OS getPlatform() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return OS.windows;
        }
        if (osName.contains("mac")) {
            return OS.macos;
        }
        if (osName.contains("solaris")) {
            return OS.solaris;
        }
        if (osName.contains("sunos")) {
            return OS.solaris;
        }
        if (osName.contains("linux")) {
            return OS.linux;
        }
        if (osName.contains("unix")) {
            return OS.linux;
        }
        return OS.unknown;
    }

    public static boolean isPortable() {
        return portable;
    }

    public static void setPortable(boolean portable) {
        PlatformUtils.portable = portable;
        workDir = PlatformUtils.getWorkingDirectory("craftland");
    }

    static {
        launcherDir = null;
        workDir = null;
    }

    public static enum OS {
        linux,
        solaris,
        windows,
        macos,
        unknown;

    }
}

