/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher.loader;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import org.craftland.launcher.loader.MainLauncher;

public class VersionHandler {
    public static String launcherURL = "http://craftland.org/mod/2.0/";
    public HashMap<String, Double> versions = new HashMap();
    public HashMap<String, String> urls = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadVersions(MainLauncher listener) throws SocketException, IOException, URISyntaxException {
        HttpURLConnection connection = null;
        try {
            String str;
            URL url = new URL(launcherURL + "launcherversion.php");
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(connection.getConnectTimeout() + 8000);
            connection.setReadTimeout(connection.getReadTimeout() + 16000);
            connection.connect();
            if (connection.getResponseCode() / 100 != 2) {
                throw new IOException("Failed to load " + url + ": " + connection.getResponseCode());
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            int i = 0;
            while ((str = in.readLine()) != null) {
                String[] setting;
                if (str.trim().startsWith("#") || (setting = str.split("=")).length < 2) continue;
                setting[0] = setting[0].trim();
                setting[1] = setting[1].trim();
                if (setting[0].startsWith("version")) {
                    try {
                        this.versions.put(setting[0].replaceFirst("version", ""), Double.valueOf(setting[1]));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (setting[0].startsWith("url")) {
                    try {
                        this.urls.put(setting[0].replaceFirst("url", ""), String.valueOf(setting[1]).replaceAll("\"", ""));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                listener.stateChanged("Checking versions", i += 5);
            }
            in.close();
            listener.stateChanged("Checking versions", 100.0f);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        if (this.versions.isEmpty() && this.urls.isEmpty()) {
            throw new IOException("Failed loading version.txt contents from " + launcherURL + "launcherversion.php\nPlease make sure that your internet works.");
        }
    }

    public double getVersion(String type) {
        return this.versions.get(type) == null ? 0.0 : this.versions.get(type);
    }

    public boolean hasVersion(String type) {
        return this.versions.get(type) != null;
    }

    public String getURL(String type) {
        return this.urls.get(type) == null ? "" : this.urls.get(type);
    }

    public static String readVersionFile(File file) throws Exception {
        DataInputStream dis = new DataInputStream(new FileInputStream(file));
        String version = dis.readUTF();
        dis.close();
        return version;
    }

    public static void writeVersionFile(File file, String version) throws Exception {
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(file));
        dos.writeUTF(version);
        dos.close();
    }

    public static void copyFile(File in, File out) throws IOException {
        FileChannel inChannel = new FileInputStream(in).getChannel();
        FileChannel outChannel = new FileOutputStream(out).getChannel();
        if (!out.exists()) {
            out.getParentFile().mkdirs();
        }
        try {
            inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }
}

