/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javafx.application.Platform;
import javafx.stage.Stage;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.craftland.launcher.Launcher;
import org.craftland.launcher.LauncherSettings;
import org.craftland.launcher.VersionHandler;
import org.craftland.launcher.WorkingDirectory;
import org.craftland.launcher.guifx.LoginController;
import org.craftland.launcher.guifx.TextDialog;
import org.craftland.launcher.updater.GameUpdater;
import org.craftland.launcher.updater.UpdateFileLibraries;
import org.craftland.util.JVMHelper;

public class GameProcess
extends Thread {
    public static String launcherClassPath;
    public static boolean preferIPV4;
    public static int sizeX;
    public static int sizeY;
    public static boolean autoConnect;
    public static boolean acceptedPrivacy;
    private LoginController loginForm;
    boolean wasUpdating = false;
    boolean exitAfter = false;
    String username = "";
    String accessToken = "-";
    String userId = "-";
    String jvmArgs = null;
    String checksum = "null";
    private int memory = 0;
    ArrayList<String> params = new ArrayList();
    ArrayList<String> args = new ArrayList();
    ArrayList<String> classpath = new ArrayList();
    private Process process;
    ArrayList<String> stdout = new ArrayList();
    TextDialog dialog = null;
    private boolean calledMain;
    static final int BUFFERSIZE = 16384;
    static int fails;

    public GameProcess() {
        super("ProcessWaiter");
    }

    public void setLoginForm(LoginController login) {
        this.loginForm = login;
    }

    public void setDialog(TextDialog dialog) {
        this.dialog = dialog;
    }

    public void setUsername(String username, String accessToken, String userId) {
        this.username = username;
        this.accessToken = accessToken;
        this.userId = userId;
    }

    public void setWasUpdating(boolean update) {
        this.wasUpdating = update;
    }

    public void setExitAfterLaunch(boolean exitAfter) {
        this.exitAfter = exitAfter;
    }

    public void setJVMArgs(String jvmArgs) {
        this.jvmArgs = jvmArgs;
    }

    public void setMemory(int memory) {
        this.memory = memory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildProcess() {
        String portable;
        File mcBinFolder = new File(WorkingDirectory.getWorkingDirectory(), "bin");
        File mcJar = GameUpdater.getGameJar();
        this.checksum = "null";
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            try (ZipFile zip = null;){
                zip = new ZipFile(mcJar);
                Enumeration zipEntries = zip.getEntries();
                while (zipEntries.hasMoreElements()) {
                    ZipArchiveEntry entry = (ZipArchiveEntry)zipEntries.nextElement();
                    if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
                    ByteBuffer buffer = ByteBuffer.allocate(8);
                    buffer.putLong(entry.getCrc());
                    md.update(buffer.array(), 0, 8);
                }
            }
            BigInteger bi = new BigInteger(1, md.digest());
            this.checksum = bi.toString(16).toLowerCase();
        }
        catch (Exception e) {
            this.checksum = e.getMessage();
        }
        if (JVMHelper.getJavaBin(this.params)) {
            System.out.println("Using JNI launcher");
        }
        if (this.memory > 0) {
            this.params.add("-Xmx" + this.memory + "m");
        }
        if (this.jvmArgs != null) {
            this.params.add(this.jvmArgs);
        }
        this.params.add("-XX:ErrorFile=jvmcrash.log");
        String nativesPath = new File(mcBinFolder, "natives").getAbsolutePath();
        this.params.add("-Dorg.lwjgl.librarypath=" + nativesPath);
        this.params.add("-Djava.library.path=" + nativesPath);
        this.params.add("-Dnet.java.games.input.librarypath=" + nativesPath);
        this.params.add("-Dorg.craftland.jarchecksum=" + this.checksum);
        this.params.add("-Dorg.craftland.mod.debug=" + (LauncherSettings.getInstance().getBoolean("debugmode", false) ? "true" : "false"));
        this.params.add("-Dorg.craftland.mod.32bitWindows=" + (Launcher.is32BitJVM && Launcher.isWindows ? "true" : "false"));
        if (WorkingDirectory.getPlatform() == WorkingDirectory.OS.macos) {
            this.params.add("-Dapple.laf.useScreenMenuBar=false");
            this.params.add("-Dcom.apple.mrj.application.apple.menu.about.name=Craftland");
            this.params.add("-Xdock:name=Craftland");
        }
        if ((portable = System.getProperty("craftlandPortable")) != null) {
            this.params.add("-DcraftlandPortable=" + portable);
        }
        this.params.add("-Dorg.craftland.mod.serverName=" + VersionHandler.serverName);
        this.params.add("-Dorg.craftland.mod.serverAddress=" + VersionHandler.serverAddr);
        this.params.add("-Dorg.craftland.mod.skinURL=" + VersionHandler.skinURL);
        if (preferIPV4) {
            this.params.add("-Djava.net.preferIPv4Stack=true");
            this.params.add("-Djava.net.preferIPv6Addresses=false");
        }
        this.params.add("-classpath");
        String separator = System.getProperty("path.separator");
        ArrayList<File> classPathFiles = GameProcess.getClasspathEntries();
        Object classPath = "";
        for (int i = 0; i < classPathFiles.size(); ++i) {
            File f = classPathFiles.get(i);
            if (i > 0) {
                classPath = (String)classPath + separator;
            }
            String filePath = f.getAbsolutePath();
            classPath = (String)classPath + filePath;
            this.classpath.add(filePath);
        }
        this.params.add((String)classPath);
        this.params.add("net.minecraft.client.Minecraft");
        this.args.addAll(GameProcess.getArgs(this.username, this.accessToken, this.userId, this.wasUpdating));
        this.params.addAll(this.args);
    }

    public void startProcess() throws Exception {
        if (this.dialog != null) {
            this.dialog.appendLine("Game is starting");
        }
        this.buildProcess();
        ProcessBuilder pb = new ProcessBuilder(this.params).redirectErrorStream(true);
        pb.directory(WorkingDirectory.getWorkingDirectory());
        this.process = pb.start();
        if (this.process != null) {
            this.start();
        }
    }

    private static ArrayList<String> getArgs(String username, String accessToken, String userId, boolean wasUpdating) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-session");
        args.add(username);
        args.add(accessToken);
        args.add(userId);
        if (LauncherSettings.getInstance().getBoolean("fullscreen", false)) {
            args.add("-fullscreen");
        }
        if (LauncherSettings.getInstance().getBoolean("restorewindow", false)) {
            args.add("-restorewindow");
        }
        if (!LauncherSettings.getInstance().getBoolean("useFBO", true)) {
            args.add("-disablefbo");
        }
        if (!LauncherSettings.getInstance().getBoolean("useGUIAnimations", true)) {
            args.add("-disableguianimations");
        }
        if (LauncherSettings.getInstance().getBoolean("controllerInput", false)) {
            args.add("-controllerInput");
        }
        if (wasUpdating) {
            args.add("-clearcache");
        }
        if (autoConnect) {
            args.add("-autoconnect");
        }
        args.add("-w");
        args.add(String.valueOf(sizeX));
        args.add("-h");
        args.add(String.valueOf(sizeY));
        return args;
    }

    public static ArrayList<File> getClasspathEntries() {
        ArrayList<File> files = new ArrayList<File>();
        File mcBinFolder = new File(WorkingDirectory.getWorkingDirectory(), "bin");
        if (launcherClassPath != null && new File(launcherClassPath).isDirectory()) {
            files.add(new File(launcherClassPath, "bin"));
            files.add(new File(launcherClassPath, "resources"));
            for (String str : UpdateFileLibraries.libararies) {
                files.add(new File(launcherClassPath, "libs" + File.separator + str));
            }
        } else {
            files.add(GameUpdater.getGameJar());
        }
        for (String str : UpdateFileLibraries.libararies) {
            files.add(new File(mcBinFolder, str));
        }
        files.add(new File(mcBinFolder, "jinput.jar"));
        files.add(new File(mcBinFolder, "lwjgl.jar"));
        files.add(new File(mcBinFolder, "lwjgl_util.jar"));
        if (LauncherSettings.getInstance().getBoolean("videorecorder", false)) {
            File mcUpdateFolder = new File(WorkingDirectory.getWorkingDirectory(), "updateFolder");
            files.add(new File(mcUpdateFolder, "xuggler.jar"));
        }
        if (LauncherSettings.getInstance().getBoolean("basslibrary", true)) {
            files.add(new File(mcBinFolder, "NativeBass.jar"));
        }
        return files;
    }

    @Override
    public void run() {
        InputStreamReader reader = new InputStreamReader(this.process.getInputStream());
        BufferedReader buf = new BufferedReader(reader);
        String line = null;
        boolean isAlive = false;
        while (this.isRunning()) {
            try {
                while ((line = buf.readLine()) != null) {
                    if (!isAlive) {
                        isAlive = true;
                        if (line.equals("START")) {
                            this.onGameAlive();
                        }
                    }
                    this.stdout.add(line);
                    if (this.dialog == null) continue;
                    this.dialog.appendLine(line);
                }
            }
            catch (IOException var8) {
                var8.printStackTrace();
                break;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        this.processEnded();
    }

    public boolean isRunning() {
        try {
            this.process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException var2) {
            return true;
        }
    }

    static String limit(String s, int mLen) {
        return s.length() > mLen ? s.substring(0, mLen) : s;
    }

    public String getLogAsString() {
        Object s = "";
        int len = this.stdout.size();
        if (len > 1000) {
            List<String> l = this.stdout.subList(0, 500);
            for (String s2 : l) {
                s = (String)s + GameProcess.limit(s2, 1024) + "\n";
            }
            s = (String)s + "--- LOG FILE STRIPPED (skipping " + (len - 1000) + " lines)\n";
            l = this.stdout.subList(len - 500, len - 1);
            for (String s2 : l) {
                s = (String)s + GameProcess.limit(s2, 1024) + "\n";
            }
        } else {
            for (String s2 : this.stdout) {
                s = (String)s + GameProcess.limit(s2, 1024) + "\n";
            }
        }
        return s;
    }

    public void processEnded() {
        int code = -1;
        try {
            code = this.process.exitValue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        final int exitCode = code;
        boolean showsError = false;
        final boolean[] maxMemoryError = new boolean[]{false};
        final String log = this.getLogAsString();
        if (!this.calledMain) {
            showsError = true;
            Launcher.uploadText(Launcher.getInstance().getLastSelectedUsername(), "Launcher failed to start game\n\n" + log, "https://craftland.org/debug/post.php?type=1");
            for (int i = 0; i < this.stdout.size(); ++i) {
                String line = this.stdout.get(i);
                System.out.println(line);
                if (!line.startsWith("Could not reserve enough space")) continue;
                maxMemoryError[0] = true;
            }
            if (this.loginForm.loginPane.getScene().getWindow().isShowing()) {
                try {
                    Platform.runLater((Runnable)new Runnable(){
                        int mem;
                        {
                            this.mem = GameProcess.this.memory;
                        }

                        @Override
                        public void run() {
                            if (maxMemoryError[0]) {
                                LoginController cfr_ignored_0 = GameProcess.this.loginForm;
                                LoginController.showErrorDialog("Failed starting Minecraft", new Exception("Could not start java with " + this.mem + " MB memory"));
                            } else {
                                if (exitCode > 0) {
                                    GameUpdater.resetStateSoft();
                                    if (fails > 0) {
                                        GameUpdater.resetState();
                                    }
                                    ++fails;
                                }
                                LoginController cfr_ignored_1 = GameProcess.this.loginForm;
                                LoginController.showErrorDialog("Failed starting Minecraft", new Exception(log + "\n\n Forcing update. Please try again"));
                            }
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            if (this.dialog != null) {
                this.dialog.appendLine("Game exited. Return code " + code);
            }
            if (code != 0) {
                System.err.println("Game seems to have crashed. Uploading logfile");
                try {
                    String data = "Full crash log\n\n" + log;
                    String jvmcrashlog = Launcher.getInstance().readAndRename(new File(WorkingDirectory.getWorkingDirectory(), "jvmcrash.log"));
                    if (jvmcrashlog != null) {
                        data = data + "\n\n------- JVM CRASH LOG --------\n" + jvmcrashlog;
                    }
                    Launcher.uploadText(Launcher.getInstance().getLastSelectedUsername(), data, "https://craftland.org/debug/post.php?type=2");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.loginForm.setLoginThread(null);
        if (this.exitAfter && !showsError) {
            System.exit(code);
        }
    }

    public void onGameAlive() {
        this.calledMain = true;
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Stage window = (Stage)GameProcess.this.loginForm.loginPane.getScene().getWindow();
                if (GameProcess.this.exitAfter && window.isShowing()) {
                    window.hide();
                } else {
                    GameProcess.this.loginForm.labelStatus.setVisible(false);
                }
            }
        });
    }

    static {
        sizeX = 854;
        sizeY = 480;
        autoConnect = false;
        acceptedPrivacy = false;
        fails = 0;
    }
}

