/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher.guifx;

import javafx.event.ActionEvent;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import org.craftland.launcher.Launcher;
import org.craftland.launcher.accounts.AccountLogins;
import org.craftland.launcher.accounts.Accounts;
import org.craftland.launcher.exception.BadLoginException;
import org.craftland.launcher.exception.MCNetworkException;
import org.craftland.launcher.exception.MigratedMojangAccountException;
import org.craftland.launcher.guifx.LoginController;
import org.craftland.launcher.mojang.Yggdrasil;
import org.craftland.launcher.mojang.YggdrasilAccount;
import org.craftland.launcher.mojang.YggdrasilResponseAuth;

public class AddAccountController {
    public TextField fieldUsername;
    public PasswordField fieldPassword;
    public CheckBox checkboxPassword;
    public Text labelMessage;
    public Button btnLogin;
    public Button btnCancel;
    private YggdrasilResponseAuth auth;
    private LoginController loginController;

    public YggdrasilResponseAuth getAuth() {
        return this.auth;
    }

    public void init(LoginController loginController) {
        this.loginController = loginController;
    }

    public void login(ActionEvent actionEvent) {
        if (this.fieldPassword.getText().length() > 0 && this.fieldUsername.getText().length() > 0) {
            this.btnLogin.setDisable(true);
            this.btnCancel.setDisable(true);
            this.fieldUsername.setEditable(false);
            this.fieldPassword.setEditable(false);
            this.labelMessage.setText("Loging in...");
            try {
                this.auth = Yggdrasil.doLogin(this.fieldUsername.getText(), this.fieldPassword.getText(), Launcher.getHTTPTimeout());
                Accounts.getInstance().putOrUpdate(new YggdrasilAccount(this.auth));
                if (this.checkboxPassword.isSelected()) {
                    AccountLogins.getInstance().setLogin(this.auth, this.fieldUsername.getText(), this.fieldPassword.getText());
                    AccountLogins.getInstance().write();
                }
                ((Stage)this.fieldPassword.getScene().getWindow()).close();
            }
            catch (MCNetworkException e) {
                this.labelMessage.setText(e.getMessage());
            }
            catch (MigratedMojangAccountException e) {
                this.labelMessage.setText(e.getMessage());
            }
            catch (BadLoginException e) {
                this.labelMessage.setText(e.getMessage());
            }
            catch (Exception e) {
                this.labelMessage.setText("Unexpected error");
                e.printStackTrace();
            }
            finally {
                this.btnLogin.setDisable(false);
                this.btnCancel.setDisable(false);
                this.fieldUsername.setEditable(true);
                this.fieldPassword.setEditable(true);
            }
        } else {
            this.labelMessage.setText("Empty username / password");
        }
    }

    public void cancel(ActionEvent actionEvent) {
        ((Stage)this.fieldPassword.getScene().getWindow()).close();
    }
}

