/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher.updater;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.craftland.launcher.LauncherSettings;
import org.craftland.launcher.LoginState;
import org.craftland.launcher.LoginThread;
import org.craftland.launcher.VersionHandler;
import org.craftland.launcher.WorkingDirectory;
import org.craftland.launcher.assets.AssetLoader;
import org.craftland.launcher.assets.Downloadable;
import org.craftland.launcher.download.Download;
import org.craftland.launcher.exception.MCNetworkException;
import org.craftland.launcher.exception.UnsupportedOSException;
import org.craftland.launcher.exception.UpdateFailedException;
import org.craftland.launcher.updater.UpdateFile;
import org.craftland.launcher.updater.UpdateFileLWJGL;
import org.craftland.launcher.updater.UpdateFileLibraries;
import org.craftland.launcher.updater.UpdateFilePreview;
import org.craftland.util.UpdateUtils;

public class GameUpdater {
    public static File binDir = null;
    public static File updateDir = null;
    public static File resourcesDir = null;
    public static UpdateFile modUpdateFileStable = null;
    public static UpdateFile modUpdateFileTesting = null;
    public static UpdateFile resUpdateFile = null;
    public static UpdateFile lwjglUpdateFile = null;
    public static UpdateFile librariesUpdateFile = null;

    public static void init() {
        String craftlandDir = WorkingDirectory.getWorkingDirectory().getPath();
        binDir = new File(craftlandDir + File.separator + "bin");
        updateDir = new File(craftlandDir + File.separator + "updateFolder");
        resourcesDir = new File(craftlandDir + File.separator + "resources");
        modUpdateFileStable = new UpdateFile("mod", null);
        modUpdateFileTesting = new UpdateFilePreview("preview", null).rewriteOutput("minecraft.jar", "preview.jar");
        resUpdateFile = new UpdateFile("resources", null);
        lwjglUpdateFile = new UpdateFileLWJGL();
        librariesUpdateFile = new UpdateFileLibraries();
    }

    private String getBassNativesName() throws UnsupportedOSException {
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        String fname = null;
        if (osName.contains("win")) {
            fname = osArch.contains("64") ? "natives_win64" : "natives_win32";
        } else if (osName.contains("linux") || osName.contains("unix")) {
            fname = osArch.contains("64") ? "natives_linux64" : "natives_linux32";
        } else if (osName.contains("mac")) {
            fname = "natives_mac";
        } else {
            throw new UnsupportedOSException();
        }
        return fname;
    }

    public void loadBassLib(LoginThread loginThread) throws Exception {
        String fname = this.getBassNativesName();
        File nativesDir = new File(binDir.getPath() + File.separator + "natives");
        if (!nativesDir.exists()) {
            nativesDir.mkdir();
        }
        if (!new File(updateDir.getPath() + File.separator + "NativeBass_jar.zip").exists()) {
            loginThread.setLoginState(LoginState.UPDATING_MOD, "Loading NativeBass_jar.zip");
            this.downloadFile(VersionHandler.getURL("bass") + "NativeBass_jar.zip", updateDir.getPath() + File.separator + "NativeBass_jar.zip", loginThread);
        }
        if (!new File(updateDir.getPath() + File.separator + fname + ".zip").exists()) {
            loginThread.setLoginState(LoginState.UPDATING_MOD, "Loading " + fname);
            this.downloadFile(VersionHandler.getURL("bass") + fname + ".zip", updateDir.getPath() + File.separator + fname + ".zip", loginThread);
        }
        UpdateUtils.extractZip(binDir, new File(updateDir.getPath() + File.separator + "NativeBass_jar.zip"), true);
        UpdateUtils.extractZip(nativesDir, new File(updateDir.getPath() + File.separator + fname + ".zip"), true);
    }

    void downloadFile(String url, String outPut, LoginThread loginThread) throws Exception {
        try {
            Download download = new Download(url, outPut);
            download.setListener(loginThread);
            download.load();
        }
        catch (ConnectException e) {
            throw new UpdateFailedException("Failed to load " + url, e, true);
        }
        catch (SocketTimeoutException e) {
            throw new UpdateFailedException("Failed to load " + url, e, true);
        }
        catch (SocketException e) {
            throw new UpdateFailedException("Failed to load " + url, e, true);
        }
    }

    public void updateResources(LoginThread loginThread) throws Exception {
        resourcesDir.mkdirs();
        resUpdateFile.update(this, loginThread);
    }

    public void udpateLWJGL(LoginThread loginThread) throws Exception {
        lwjglUpdateFile.deleteVersion();
        lwjglUpdateFile.update(this, loginThread);
    }

    public boolean canWriteLWJGL() {
        File f1;
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win") && (f1 = new File(binDir, "natives")).isDirectory()) {
            File f2 = new File(f1, "lwjgl.dll");
            if (!f2.canWrite()) {
                return false;
            }
            File f3 = new File(f1, "lwjgl64.dll");
            if (!f3.canWrite()) {
                return false;
            }
        }
        return true;
    }

    public void updateMod(LoginThread loginThread) throws Exception {
        updateDir.mkdirs();
        modUpdateFileStable.deleteVersion();
        modUpdateFileTesting.deleteVersion();
        loginThread.setLoginState(LoginState.UPDATING_MOD, "Cleanup bin folder");
        if (binDir.exists()) {
            UpdateUtils.purgeDir(binDir);
        }
        binDir.mkdirs();
        modUpdateFileStable.update(this, loginThread);
        if (LauncherSettings.getInstance().getBoolean("previewmode")) {
            modUpdateFileTesting.update(this, loginThread);
        }
    }

    public static void resetState() {
        UpdateUtils.purgeDir(new File(updateDir, "mod.zip"));
        UpdateUtils.purgeDir(new File(updateDir, "bassnatives.zip"));
        UpdateUtils.purgeDir(new File(updateDir, "NativeBass_jar.zip"));
        UpdateUtils.purgeDir(binDir);
        modUpdateFileStable.deleteVersion();
        modUpdateFileTesting.deleteVersion();
        lwjglUpdateFile.deleteVersion();
        resUpdateFile.deleteVersion();
    }

    public static void resetStateSoft() {
        modUpdateFileStable.deleteVersion();
        modUpdateFileTesting.deleteVersion();
        lwjglUpdateFile.deleteVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProfiles(LoginThread loginThread, boolean force) throws Exception {
        loginThread.setLoginState(LoginState.STARTING_MINECRAFT, "Loading resources");
        String profileURL = VersionHandler.getURL("profiles");
        String profilespath = VersionHandler.getURL("profilesPath");
        if (profileURL.isEmpty()) {
            return;
        }
        if (profilespath.isEmpty()) {
            return;
        }
        HttpURLConnection connection = null;
        HashMap<String, String> files = new HashMap<String, String>();
        try (InputStream stream = null;){
            String str;
            URL url = new URL(profileURL + "?v=1");
            connection = (HttpURLConnection)url.openConnection();
            connection.setUseCaches(false);
            connection.setDefaultUseCaches(false);
            connection.setRequestProperty("Cache-Control", "no-store,max-age=0,no-cache");
            connection.setRequestProperty("Expires", "0");
            connection.setRequestProperty("Pragma", "no-cache");
            connection.setConnectTimeout(20000);
            connection.setReadTimeout(30000);
            connection.connect();
            if (connection.getResponseCode() / 100 != 2) {
                throw new IOException("Failed to load " + url + ": " + connection.getResponseCode());
            }
            stream = connection.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(stream));
            while ((str = in.readLine()) != null) {
                String[] split;
                if ((str = str.trim()).startsWith("#") || str.isEmpty() || (split = str.split(";")).length != 2) continue;
                files.put(split[0], split[1]);
            }
        }
        boolean v = false;
        Set c = files.entrySet();
        int size = c.size();
        int i = 0;
        for (Map.Entry entry : files.entrySet()) {
            String fMD5 = (String)entry.getValue();
            String encoded = ((String)entry.getKey()).replaceAll(" ", "%20");
            File fileToLoad = new File(WorkingDirectory.getWorkingDirectory().getPath(), (String)entry.getKey());
            String fMD5_LOCAL = fileToLoad.exists() ? UpdateUtils.getFileMD5(fileToLoad) : "";
            boolean uptodate = fMD5.equalsIgnoreCase(fMD5_LOCAL);
            if (!uptodate) {
                if (!fileToLoad.getParentFile().exists()) {
                    fileToLoad.getParentFile().mkdirs();
                }
                loginThread.setLoginState(LoginState.LOADING_ASSETS, "Loading Craftland Assets");
                loginThread.stateChanged((String)entry.getKey(), (int)((float)i / (float)size * 100.0f));
                this.downloadFile(profilespath + encoded, fileToLoad.getAbsolutePath(), null);
            }
            ++i;
        }
    }

    public void updateLibraries(LoginThread loginThread) throws Exception {
        String fname = this.getBassNativesName();
        File bassLib = new File(updateDir.getPath() + File.separator + fname + ".zip");
        bassLib.delete();
        librariesUpdateFile.deleteVersion();
        librariesUpdateFile.update(this, loginThread);
    }

    public void loadAssets(LoginThread loginThread) throws IOException {
        loginThread.setLoginState(LoginState.STARTING_MINECRAFT, "Loading Minecraft Assets");
        AssetLoader l = new AssetLoader("1.8.9", "1.8");
        HashSet<Downloadable> set = l.load();
        long totalBytes = 0L;
        for (Downloadable d : set) {
            totalBytes += d.getExpectedSize();
        }
        long loadedBytes = 0L;
        boolean v = false;
        File vanillaDir = WorkingDirectory.getVanillaWorkingDirectory();
        for (Downloadable d : set) {
            try {
                if (d.getStatus() == Downloadable.Status.UPTODATE) continue;
                if (!v) {
                    v = true;
                    loginThread.setLoginState(LoginState.LOADING_ASSETS, "Loading Minecraft Assets");
                }
                d.tryCopyFromVanilla(vanillaDir);
                while (d.getNumAttempts() < 10) {
                    try {
                        d.download();
                    }
                    catch (MCNetworkException e) {
                        if (d.getNumAttempts() > 9) {
                            throw new RuntimeException("Minecraft assets servers are slow. Please try again later");
                        }
                        loginThread.setLoginState(LoginState.LOADING_ASSETS, "Slow minecraft server... will retry");
                        try {
                            Thread.sleep(1100L);
                        }
                        catch (Exception exception) {}
                    }
                }
                loadedBytes += d.getExpectedSize();
                int progress = (int)((float)(++loadedBytes) / (float)totalBytes * 100.0f);
                loginThread.stateChanged(d.getOut(), progress);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        loginThread.setLoginState(LoginState.STARTING_MINECRAFT, "Validating Minecraft Assets");
        File dirAssets = l.reconstructAssets(resourcesDir);
        if (!dirAssets.isDirectory()) {
            System.err.println("Failed to make assets folder!");
        }
    }

    public static File getGameJar() {
        if (LauncherSettings.getInstance().getBoolean("previewmode")) {
            return new File(binDir, "preview.jar");
        }
        return new File(binDir, "minecraft.jar");
    }

    public static UpdateFile getGameUpdateFile() {
        return LauncherSettings.getInstance().getBoolean("previewmode") ? modUpdateFileTesting : modUpdateFileStable;
    }
}

