/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher.updater;

import java.io.File;
import java.io.IOException;
import org.craftland.launcher.Launcher;
import org.craftland.launcher.LoginThread;
import org.craftland.launcher.WorkingDirectory;
import org.craftland.launcher.exception.UpdateFailedException;
import org.craftland.launcher.updater.GameUpdater;
import org.craftland.launcher.updater.UpdateFile;
import org.craftland.util.UpdateUtils;

public class UpdateFileLWJGL
extends UpdateFile {
    public UpdateFileLWJGL() {
        super("lwjgl", null);
        String osName = System.getProperty("os.name").toLowerCase();
        this.name = osName.contains("win") ? "win_lwjgl" : (osName.contains("mac") ? (Launcher.isOldAppleJAVA ? "mac_16_lwjgl" : "mac_lwjgl") : (osName.contains("solaris") || osName.contains("sunos") ? "sun_lwjgl" : "linux_lwjgl"));
    }

    @Override
    public void extract(LoginThread loginThread) throws IOException, UpdateFailedException {
        File newLib;
        File natives;
        super.extract(loginThread);
        if (Launcher.isOldAppleJAVA && (natives = new File(GameUpdater.binDir, "natives")).isDirectory() && (newLib = new File(natives, "liblwjgl.dylib")).exists()) {
            newLib.delete();
        }
    }

    @Override
    public boolean needsUpdate() throws Exception {
        File newLib;
        if (super.needsUpdate()) {
            return true;
        }
        if (!GameUpdater.updateDir.exists()) {
            return true;
        }
        if (!GameUpdater.binDir.exists()) {
            return true;
        }
        File nativesDir = new File(GameUpdater.binDir, "natives");
        if (!nativesDir.exists()) {
            return true;
        }
        if (!nativesDir.isDirectory()) {
            nativesDir.delete();
            return true;
        }
        File lwjglJar = new File(GameUpdater.binDir, "lwjgl.jar");
        File jinputJar = new File(GameUpdater.binDir, "jinput.jar");
        File lwjglUtilJar = new File(GameUpdater.binDir, "lwjgl_util.jar");
        File[] files = new File[]{lwjglJar, jinputJar, lwjglUtilJar};
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].exists()) {
                return true;
            }
            if (UpdateUtils.validateZipFileIntegrity(files[i])) continue;
            return true;
        }
        if (Launcher.isOldAppleJAVA && (newLib = new File(nativesDir, "liblwjgl.dylib")).exists()) {
            return true;
        }
        if (WorkingDirectory.getPlatform() == WorkingDirectory.OS.windows) {
            File dllFile = new File(nativesDir, "lwjgl.dll");
            if (!dllFile.isFile()) {
                return true;
            }
            dllFile = new File(nativesDir, "lwjgl64.dll");
            if (!dllFile.isFile()) {
                return true;
            }
        }
        return false;
    }
}

