/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.util;

import java.awt.Desktop;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;

public class DesktopUtils {
    public static void open(String url) {
        try {
            DesktopUtils.open(new URL(url).toURI());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Invalid path: " + url, "Cannot Launch Link", 2);
        }
    }

    public static void open(URL url) {
        try {
            DesktopUtils.open(url.toURI());
        }
        catch (URISyntaxException e) {
            JOptionPane.showMessageDialog(null, "Invalid path: " + url, "Cannot Launch Link", 2);
        }
    }

    public static void open(URI uri) {
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(uri);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "Failed to open: " + uri, "Cannot Launch Link", 2);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Java is not able to launch links on your computer.", "Cannot Launch Link", 2);
        }
    }

    public static void setOSXDockIcon() {
        block5: {
            try {
                System.setProperty("apple.laf.useScreenMenuBar", "false");
                System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Craftland Launcher");
                BufferedImage image = ImageIO.read(DesktopUtils.class.getResourceAsStream("/img/cube128.png"));
                if (image == null) break block5;
                try {
                    Method m2;
                    Object o;
                    Method m;
                    Class<?> c = Class.forName("com.apple.eawt.Application");
                    if (c != null && (m = c.getMethod("getApplication", new Class[0])) != null && (o = m.invoke(null, new Object[0])) != null && (m2 = o.getClass().getMethod("setDockIconImage", Image.class)) != null) {
                        m2.invoke(o, image);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

