/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.util;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.SwingWorker;

public abstract class ImageLoader
extends SwingWorker {
    protected String URL;
    protected BufferedImage image;
    private String error;
    private int timeout = 30000;

    public ImageLoader(String URL2) {
        this.URL = URL2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doInBackground() throws Exception {
        HttpURLConnection connection = null;
        InputStream stream = null;
        try {
            URL url = new URL(this.URL);
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(this.timeout);
            connection.setReadTimeout(this.timeout);
            connection.connect();
            if (connection.getResponseCode() / 100 != 2) {
                throw new IOException("Failed to load " + url + ": " + connection.getResponseCode());
            }
            stream = connection.getInputStream();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buf = new byte[16384];
            int l = 0;
            while ((l = stream.read(buf)) > 0) {
                os.write(buf, 0, l);
            }
            ByteArrayInputStream stream2 = new ByteArrayInputStream(os.toByteArray());
            this.image = ImageIO.read(stream2);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error = "" + e;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    @Override
    public abstract void done();

    public void runSync() {
        try {
            this.doInBackground();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getError() {
        return this.error;
    }

    public void setTimeout(int i) {
        this.timeout = i;
    }
}

