/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.craftland.launcher.exception.UpdateFailedException;

public class UpdateUtils {
    public static void purgeDir(File file) {
        File delFile = file;
        if (delFile.exists()) {
            if (delFile.isDirectory()) {
                UpdateUtils.deleteSubDir(delFile);
            }
            delFile.delete();
        }
    }

    static void deleteSubDir(File argFile) {
        for (File file : argFile.listFiles()) {
            if (file.isDirectory()) {
                UpdateUtils.deleteSubDir(file);
            }
            file.delete();
        }
    }

    public static void extractZip(File nativesDir, File nativesJar, boolean ignoreifcannotwrite) throws Exception {
        if (!nativesDir.exists()) {
            nativesDir.mkdir();
        }
        ZipFile zip = null;
        InputStream lastZipIs = null;
        int i = 0;
        OutputStream out = null;
        try {
            zip = new ZipFile(nativesJar);
            Enumeration zipEntries = zip.getEntries();
            byte[] bytes = new byte[16384];
            while (zipEntries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)zipEntries.nextElement();
                String name = entry.getName();
                if (entry.isDirectory()) continue;
                if (!zip.canReadEntryData(entry)) {
                    throw new UpdateFailedException("Invalid zip file: " + nativesJar, new Exception("Expected non-empty zip file " + nativesJar), true);
                }
                lastZipIs = zip.getInputStream(entry);
                try {
                    out = new FileOutputStream(new File(nativesDir.getPath() + File.separator + name));
                    int read = 0;
                    while ((read = lastZipIs.read(bytes)) != -1) {
                        out.write(bytes, 0, read);
                    }
                    out.flush();
                }
                catch (FileNotFoundException ex) {
                    if (ignoreifcannotwrite) continue;
                    throw ex;
                }
                finally {
                    if (out == null) continue;
                    out.close();
                    continue;
                }
                lastZipIs.close();
                ++i;
            }
        }
        catch (ZipException zex) {
            throw new UpdateFailedException("Invalid zip file: " + nativesJar, new Exception("Expected valid zip file " + nativesJar), true);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (zip != null) {
                zip.close();
            }
            if (lastZipIs != null) {
                lastZipIs.close();
            }
        }
        if (i == 0) {
            System.err.println("Did not extract any files from " + nativesJar);
        }
    }

    public static void writeTextFile(File out, String contents) {
        FileWriter fWriter = null;
        BufferedWriter writer = null;
        try {
            fWriter = new FileWriter(out);
            writer = new BufferedWriter(fWriter);
            writer.write(contents);
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getFileMD5(File file) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            FileInputStream is = new FileInputStream(file);
            byte[] buffer = new byte[8192];
            int read = 0;
            while ((read = ((InputStream)is).read(buffer)) > 0) {
                md.update(buffer, 0, read);
            }
            ((InputStream)is).close();
            byte[] md5 = md.digest();
            BigInteger bi = new BigInteger(1, md5);
            String strMD = bi.toString(16).toLowerCase();
            return ("00000000000000000000000000000000" + strMD).substring(strMD.length());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static void copyFile(File in, File out) throws IOException {
        FileInputStream instream = new FileInputStream(in);
        FileChannel inChannel = instream.getChannel();
        if (!out.exists()) {
            out.getParentFile().mkdirs();
        }
        FileOutputStream outstream = new FileOutputStream(out);
        FileChannel outChannel = outstream.getChannel();
        try {
            inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
            if (instream != null) {
                instream.close();
            }
            if (outstream != null) {
                outstream.close();
            }
        }
    }

    public static boolean validateZipFileIntegrity(File file) {
        ZipFile zip = null;
        try {
            zip = new ZipFile(file);
            zip.getEntries();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (zip != null) {
                ZipFile.closeQuietly((ZipFile)zip);
            }
        }
        return false;
    }
}

