/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher;

import com.sun.management.OperatingSystemMXBean;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import javafx.application.Application;
import javafx.concurrent.Task;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.io.IOUtils;
import org.craftland.launcher.LauncherSettings;
import org.craftland.launcher.Main;
import org.craftland.launcher.VersionHandler;
import org.craftland.launcher.WorkingDirectory;
import org.craftland.launcher.accounts.Account;
import org.craftland.launcher.accounts.AccountLogins;
import org.craftland.launcher.accounts.Accounts;
import org.craftland.launcher.accounts.UserLogin;
import org.craftland.launcher.guifx.LoginController;
import org.craftland.launcher.updater.GameUpdater;
import org.craftland.util.JVMHelper;

public class Launcher
extends Application {
    static final Launcher instance = new Launcher();
    public static final int HTTP_TIMEOUT = 30000;
    public static final int HTTP_CONNECT_TIMEOUT = 20000;
    public static boolean is64bit = false;
    public static boolean is32BitJVM = true;
    public static boolean isWindows = true;
    public static boolean shouldUpgradeJava = false;
    public static boolean isOldAppleJAVA = false;
    static final String Boundary = "--7d021a37605f0";
    public static final String debugPostURL = "https://craftland.org/debug/post.php?type=1";
    public static final String debugPostURL2 = "https://craftland.org/debug/post.php?type=2";
    private LoginController form;

    public static Launcher getInstance() {
        return instance;
    }

    public void loadAccounts() {
        Accounts accs = Accounts.getInstance();
        AccountLogins logins = AccountLogins.getInstance();
        try {
            try {
                accs.load();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            boolean save = logins.readAndDeleteLastloginFile(accs);
            logins.load();
            Iterator<UserLogin> it = logins.getLogins().iterator();
            while (it.hasNext()) {
                UserLogin l = it.next();
                if (accs.getAccountID(l.getID()) != null) continue;
                System.out.println("removed " + l.getLogin());
                it.remove();
                save = true;
            }
            if (save) {
                logins.write();
                accs.write();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LoginController.showErrorDialog("Failed loading accounts\n" + e.getClass() + ": " + e.getMessage(), e);
        }
    }

    public void show() {
        Application.launch((String[])new String[0]);
        System.exit(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initSettings() {
        try {
            is32BitJVM = "x86".equals(System.getProperty("os.arch"));
            isWindows = System.getProperty("os.name").contains("Windows");
            is64bit = isWindows ? System.getenv("ProgramFiles(x86)") != null : System.getProperty("os.arch").contains("64");
            boolean bl = shouldUpgradeJava = is32BitJVM && isWindows && is64bit;
            if (WorkingDirectory.getPlatform() == WorkingDirectory.OS.macos) {
                ArrayList<String> params = new ArrayList<String>();
                JVMHelper.getJavaBin(params);
                String response = JVMHelper.getJavaVersionResponse(params);
                if (response != null && response.startsWith("java version \"1.6.")) {
                    isOldAppleJAVA = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LauncherSettings.getInstance().load();
        int current = Launcher.getMemorySetting();
        if (current == 0 || is64bit && isWindows && current == 1) {
            int newM = current;
            if (is32BitJVM) {
                newM = 2;
            } else {
                try {
                    Class.forName("com.sun.management.OperatingSystemMXBean");
                    Class.forName("java.lang.management.ManagementFactory");
                    OperatingSystemMXBean os = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
                    long physicalMemorySize = os.getTotalPhysicalMemorySize() / 0x100000L;
                    int setting = 2;
                    if (physicalMemorySize > 6000L) {
                        setting = 3;
                    }
                    newM = setting;
                }
                catch (Throwable exception) {
                    exception.printStackTrace();
                }
            }
            if (newM > current) {
                LauncherSettings.getInstance().setInteger("memory", newM);
            }
        }
        FileInputStream is = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            File file = new File(System.getProperty("java.home"), "lib/security/cacerts");
            is = new FileInputStream(file);
            keyStore.load(is, "changeit".toCharArray());
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            try {
                InputStream caInput = Launcher.class.getResourceAsStream("ca_letsencyrpt.cer");
                Certificate crt = cf.generateCertificate(caInput);
                System.out.println("Added Cert for " + ((X509Certificate)crt).getSubjectDN());
                keyStore.setCertificateEntry("DSTRootCAX3", crt);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, tmf.getTrustManagers(), null);
            SSLContext.setDefault(sslContext);
            if (is == null) return;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return;
    }

    public static void uploadText(final String user, final String data, final String sturl) {
        Runnable upload = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block6: {
                    OutputStream os = null;
                    InputStream is = null;
                    try {
                        URL url = new URL(sturl);
                        HttpsURLConnection theUrlConnection = (HttpsURLConnection)url.openConnection();
                        theUrlConnection.setConnectTimeout(20000);
                        theUrlConnection.setReadTimeout(30000);
                        theUrlConnection.setDoOutput(true);
                        theUrlConnection.setDoInput(true);
                        theUrlConnection.setUseCaches(false);
                        theUrlConnection.setChunkedStreamingMode(1024);
                        theUrlConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=--7d021a37605f0");
                        os = theUrlConnection.getOutputStream();
                        DataOutputStream httpOut = new DataOutputStream(os);
                        Object str = "----7d021a37605f0\r\nContent-Disposition: form-data;name=\"message\"\r\n\r\n" + data + "\r\n";
                        httpOut.write(((String)str).getBytes());
                        httpOut.flush();
                        str = "----7d021a37605f0\r\nContent-Disposition: form-data;name=\"name\"\r\n\r\n" + user + "\r\n";
                        httpOut.write(((String)str).getBytes());
                        httpOut.flush();
                        str = "----7d021a37605f0\r\n";
                        httpOut.write(((String)str).getBytes());
                        httpOut.write(((String)str).getBytes());
                        httpOut.close();
                        is = theUrlConnection.getInputStream();
                        StringBuilder response = new StringBuilder();
                        byte[] respBuffer = new byte[4096];
                        while (is.read(respBuffer) >= 0) {
                            response.append(new String(respBuffer).trim());
                        }
                        is.close();
                        System.out.println(response.toString());
                        IOUtils.closeQuietly((OutputStream)os);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        break block6;
                    }
                    finally {
                        IOUtils.closeQuietly(os);
                        IOUtils.closeQuietly(is);
                    }
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
        };
        Thread uploadTexture = new Thread(upload);
        uploadTexture.setDaemon(true);
        uploadTexture.setPriority(1);
        uploadTexture.start();
    }

    private static int getMemorySetting() {
        return LauncherSettings.getInstance().getInt("memory", 0);
    }

    public static int getHTTPTimeout() {
        return 30000;
    }

    public String getLastSelectedUsername() {
        Account auth = Accounts.getInstance().getModelItem(0);
        String username = null;
        if (auth != null) {
            username = auth.getUsername();
        }
        if (username == null) {
            username = "Unknown";
        }
        return username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readAndRename(File logfile) {
        Object s = null;
        if (logfile.exists() && logfile.canRead()) {
            long l = logfile.length();
            s = "";
            s = (String)s + logfile.getName();
            s = (String)s + " - length: ";
            s = (String)s + l;
            s = (String)s + " - age: ";
            s = (String)s + (System.currentTimeMillis() - logfile.lastModified()) / 1000L;
            s = (String)s + "\n";
            FileReader reader = null;
            try {
                String line;
                reader = new FileReader(logfile);
                BufferedReader breader = new BufferedReader(reader);
                int nLines = 0;
                while ((line = breader.readLine()) != null) {
                    s = (String)s + line + "\n";
                    if (++nLines < 1000 && ((String)s).length() <= 0x200000) continue;
                    s = (String)s + "\n\n\n--------  File too big -------";
                    break;
                }
                reader.close();
                File f2 = new File(logfile.getAbsolutePath() + ".1");
                if (f2.exists()) {
                    f2.delete();
                }
                logfile.renameTo(f2);
            }
            catch (Throwable exception) {
                try {
                    exception.printStackTrace();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)reader);
            }
            IOUtils.closeQuietly((Reader)reader);
        }
        return s;
    }

    public void start(final Stage primaryStage) throws Exception {
        final Stage stage = new Stage(StageStyle.TRANSPARENT);
        stage.setTitle("Craftland Launcher - Loading");
        Parent root = (Parent)FXMLLoader.load((URL)((Object)((Object)this)).getClass().getResource("guifx/splash.fxml"));
        Scene scene = new Scene(root);
        scene.setFill((Paint)Color.TRANSPARENT);
        stage.setScene(scene);
        Object[] icons = new Image[]{new Image(((Object)((Object)this)).getClass().getResource("/img/cube16.png").toExternalForm()), new Image(((Object)((Object)this)).getClass().getResource("/img/cube32.png").toExternalForm()), new Image(((Object)((Object)this)).getClass().getResource("/img/cube128.png").toExternalForm()), new Image(((Object)((Object)this)).getClass().getResource("/img/favicon.png").toExternalForm())};
        stage.getIcons().addAll(icons);
        stage.centerOnScreen();
        stage.show();
        Task<Void> load = new Task<Void>((Image[])icons){
            final /* synthetic */ Image[] val$icons;
            {
                this.val$icons = imageArray;
            }

            protected Void call() throws Exception {
                Launcher.this.initSettings();
                GameUpdater.init();
                VersionHandler.loadVersions(Launcher.getHTTPTimeout());
                Launcher.this.loadAccounts();
                return null;
            }

            protected void succeeded() {
                try {
                    Parent root = (Parent)FXMLLoader.load((URL)((Object)((Object)this)).getClass().getResource("guifx/login.fxml"));
                    Scene mainScene = new Scene(root);
                    double version = GameUpdater.getGameUpdateFile().getLocalVersion();
                    if (version > 0.0) {
                        primaryStage.setTitle("Craftland Launcher " + VersionHandler.getLauncherVersion() + " - Mod Version: " + version);
                    }
                    primaryStage.setTitle("Craftland Launcher " + VersionHandler.getLauncherVersion());
                    primaryStage.setScene(mainScene);
                    primaryStage.show();
                    stage.close();
                    primaryStage.getIcons().addAll((Object[])this.val$icons);
                    Main.checkLoaderVersion();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        Thread th = new Thread((Runnable)load);
        th.start();
    }
}

