/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.craftland.launcher.GameProcess;
import org.craftland.launcher.Launcher;
import org.craftland.launcher.VersionHandler;
import org.craftland.launcher.WorkingDirectory;
import org.craftland.launcher.download.Download;
import org.craftland.launcher.updater.GameUpdater;
import org.craftland.util.DesktopUtils;
import org.craftland.util.JVMHelper;
import org.craftland.util.UpdateUtils;

public class Main {
    public static int getInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static void checkLoaderVersion() {
        System.out.println("Launcher dir: " + WorkingDirectory.getLauncherDirectory().getAbsolutePath());
        if (!Files.exists(Path.of(WorkingDirectory.getLauncherDirectory().getAbsolutePath(), "../lib"), new LinkOption[0])) {
            System.out.println("App dir does not exists. Probably running without Craftland Runtime... skipping updating the loader.");
            return;
        }
        boolean shouldRestart = VersionHandler.getVersion("launcher") > VersionHandler.getLauncherVersion();
        File loaderFile = new File(WorkingDirectory.getLauncherDirectory(), "../lib" + File.separator + "loader.jar");
        if (!loaderFile.exists() || !UpdateUtils.getFileMD5(loaderFile).equals(VersionHandler.getHash("newloader"))) {
            String loader = VersionHandler.getURL("newloader");
            if (!loader.isEmpty()) {
                if (loaderFile.exists()) {
                    System.out.println("Loader exists, but different -- deleting: old = " + UpdateUtils.getFileMD5(loaderFile) + ", new = " + VersionHandler.getHash("newloader"));
                }
                loaderFile.delete();
                System.out.println("Loader exists, but different -- deleted");
                try {
                    System.out.println("Loader downloading");
                    Download download = new Download(loader, loaderFile.getAbsolutePath());
                    download.load();
                    System.out.println("Loader downloaded");
                    shouldRestart = true;
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Failed downloading the launcher-loader\n" + e.getClass() + ": " + e.getMessage(), "An error occured", 0);
                }
            } else {
                System.out.println("loader str is empty...");
            }
        } else {
            System.out.println("Loader OK");
        }
        if (shouldRestart) {
            int result = JOptionPane.showConfirmDialog(null, "The launcher needs to be restarted to apply changes.\nRestart now?", "Launcher updated", 0);
            if (result != 0) {
                return;
            }
            try {
                ArrayList<String> params = new ArrayList<String>();
                JVMHelper.getJavaBin(params);
                if (GameProcess.preferIPV4) {
                    params.add("-Djava.net.preferIPv4Stack=true");
                    params.add("-Djava.net.preferIPv6Addresses=false");
                }
                if (System.getProperty("launcher.jredir") != null) {
                    params.add("-Dlauncher.jredir=" + System.getProperty("launcher.jredir"));
                }
                params.add("-classpath");
                params.add(loaderFile.getAbsolutePath());
                params.add("org.craftland.launcher.loader.MainLauncher");
                if (GameProcess.preferIPV4) {
                    params.add("--preferipv4");
                }
                ProcessBuilder pb = new ProcessBuilder(params);
                pb.directory(WorkingDirectory.getLauncherDirectory());
                System.out.println(pb.command());
                Process process = pb.start();
                if (process == null) {
                    throw new Exception("!");
                }
                System.exit(0);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Couldn't restart the launcher\n" + e.getClass() + ": " + e.getMessage(), "An error occured", 0);
                System.exit(1);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println("OK_OK");
        try {
            int result;
            if (WorkingDirectory.getPlatform() == WorkingDirectory.OS.macos) {
                DesktopUtils.setOSXDockIcon();
            }
            for (int i = 0; i < args.length; ++i) {
                try {
                    if (args[i].equals("--preferipv4")) {
                        GameProcess.preferIPV4 = true;
                        continue;
                    }
                    if (args[i].equals("--url") && i + 1 < args.length) {
                        VersionHandler.launcherURL = args[++i].replaceAll("'|\"", "");
                        System.out.println("Using custom launcher url '" + VersionHandler.launcherURL + "'");
                        continue;
                    }
                    if (args[i].equals("--classpath") && i + 1 < args.length) {
                        GameProcess.launcherClassPath = args[++i].replaceAll("'|\"", "");
                        System.out.println("Using custom launcher classpath '" + GameProcess.launcherClassPath + "'");
                        continue;
                    }
                    if (args[i].equals("--width") && i + 1 < args.length) {
                        int width = Main.getInt(args[i + 1]);
                        if (width <= 0) continue;
                        GameProcess.sizeX = width;
                        continue;
                    }
                    if (args[i].equals("--height") && i + 1 < args.length) {
                        int height = Main.getInt(args[i + 1]);
                        if (height <= 0) continue;
                        GameProcess.sizeY = height;
                        continue;
                    }
                    if (args[i].equals("--autoconnect")) {
                        GameProcess.autoConnect = true;
                        continue;
                    }
                    if (!args[i].equals("--portable")) continue;
                    WorkingDirectory.setPortable(true);
                    System.out.println("portable dir: " + WorkingDirectory.getWorkingDirectory().getAbsolutePath());
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Failed parsing arguments");
                    e.printStackTrace();
                }
            }
            if (!WorkingDirectory.getWorkingDirectory().exists()) {
                WorkingDirectory.getWorkingDirectory().mkdirs();
            }
            Launcher launcher = Launcher.getInstance();
            launcher.initSettings();
            GameUpdater.init();
            if (Launcher.shouldUpgradeJava && (result = JOptionPane.showConfirmDialog(null, "You are running a 32 Bit Java version on a 64 Bit Windows.\nIts recommended you upgrade Java now.\n\nDo you want to visit a download page (http://www.oracle.com/technetwork/java/javase/downloads/jre8-downloads-2133155.html)?", "Update java", 0)) == 0) {
                DesktopUtils.open("http://www.oracle.com/technetwork/java/javase/downloads/jre8-downloads-2133155.html");
                System.exit(0);
                return;
            }
            launcher.show();
        }
        catch (Exception n) {
            n.printStackTrace();
            JOptionPane.showMessageDialog(null, "Failed starting the launcher.\n" + n + "\n" + n.getMessage(), "An error occured", 0);
            System.exit(1);
        }
    }
}

