/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.craftland.launcher.WorkingDirectory;

public class MinecraftOptionsHelper {
    static HashMap<String, String> mcOptions = new HashMap();
    private static final ParameterizedType typeListString = new ParameterizedType(){

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{String.class};
        }

        @Override
        public Type getRawType() {
            return List.class;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    };

    public static void loadOptions() {
        mcOptions.clear();
        File f = new File(WorkingDirectory.getWorkingDirectory(), "options.txt");
        if (f.exists()) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(f));
                while ((line = br.readLine()) != null) {
                    String[] args;
                    if (line.isEmpty() || line.startsWith("#") || !line.contains(":") || (args = line.split(":", 2)).length < 2) continue;
                    mcOptions.put(args[0], args[1]);
                }
                br.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void saveOptions() {
        File f = new File(WorkingDirectory.getWorkingDirectory(), "options.txt");
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        try {
            BufferedWriter br = new BufferedWriter(new FileWriter(f));
            for (Map.Entry<String, String> entry : mcOptions.entrySet()) {
                br.write(entry.getKey() + ":" + entry.getValue());
                br.newLine();
            }
            br.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void setActiveTexturePack(String outPath) {
        try {
            ArrayList<String> resourcePacks;
            MinecraftOptionsHelper.loadOptions();
            String currentStr = mcOptions.get("resourcePacks");
            Gson gson = new Gson();
            ArrayList<String> arrayList = resourcePacks = currentStr == null ? null : (ArrayList<String>)gson.fromJson(currentStr, (Type)typeListString);
            if (resourcePacks == null) {
                resourcePacks = new ArrayList<String>();
            }
            if (!resourcePacks.contains(outPath)) {
                resourcePacks.add(0, outPath);
            }
            String s = gson.toJson(resourcePacks);
            mcOptions.put("resourcePacks", s);
            MinecraftOptionsHelper.saveOptions();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

