/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;

public class VersionHandler {
    private static final double launcherVersion = 4.0;
    private static HashMap<String, String> strings = new HashMap();
    private static HashMap<String, Double> versions = new HashMap();
    private static HashMap<String, String> urls = new HashMap();
    private static HashMap<String, String> fileHashs = new HashMap();
    public static String launcherURL = "https://craftland.org/mod/2.0/";
    public static String serverName = "Craftland";
    public static String serverAddr = "craftland.org:25566";
    public static String skinURL = "https://s3.amazonaws.com/MinecraftSkins/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadVersions(int httpTimeout) throws IOException, URISyntaxException {
        HttpURLConnection connection = null;
        try (InputStream is = null;){
            String str;
            URL url = new URL(launcherURL + "launcherversion.php");
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(httpTimeout);
            connection.setReadTimeout(httpTimeout);
            connection.connect();
            if (connection.getResponseCode() / 100 != 2) {
                throw new IOException("Failed to load " + url + ": " + connection.getResponseCode());
            }
            is = connection.getInputStream();
            InputStreamReader read = new InputStreamReader(is);
            BufferedReader in = new BufferedReader(read);
            while ((str = in.readLine()) != null) {
                String[] setting;
                if (str.trim().startsWith("#") || (setting = str.split("=")).length < 2) continue;
                setting[0] = setting[0].trim();
                setting[1] = setting[1].trim();
                try {
                    if (setting[0].startsWith("version")) {
                        versions.put(setting[0].replaceFirst("version", ""), Double.valueOf(setting[1]));
                        continue;
                    }
                    if (setting[0].startsWith("url")) {
                        urls.put(setting[0].replaceFirst("url", ""), String.valueOf(setting[1]).replaceAll("\"", ""));
                        continue;
                    }
                    if (setting[0].startsWith("hash")) {
                        fileHashs.put(setting[0].replaceFirst("hash", ""), String.valueOf(setting[1]).replaceAll("\"", "").toLowerCase());
                        continue;
                    }
                    if (setting[0].equals("serverAddress")) {
                        serverAddr = setting[1];
                        continue;
                    }
                    if (setting[0].equals("serverName")) {
                        serverName = setting[1];
                        continue;
                    }
                    if (setting[0].equals("skinURL")) {
                        skinURL = setting[1];
                        continue;
                    }
                    strings.put(setting[0], String.valueOf(setting[1]).replaceAll("\"", ""));
                }
                catch (Exception e) {
                    throw new IOException("Failed parsing launcher version settings\nInvalid version data loaded from " + url.toString() + "\nPlease report this error");
                }
            }
            if (urls.isEmpty()) {
                throw new IOException("Empty launcher version settings\nPlease report this error");
            }
        }
        String overrideSrvAddr = System.getProperty("org.craftland.mod.serverAddress");
        String overrideSrvName = System.getProperty("org.craftland.mod.serverName");
        String overrideSkinURL = System.getProperty("org.craftland.mod.skinURL");
        if (overrideSrvName != null) {
            serverName = overrideSrvName;
        }
        if (overrideSrvAddr != null) {
            serverAddr = overrideSrvAddr;
        }
        if (overrideSkinURL != null) {
            skinURL = overrideSkinURL;
        }
    }

    public static double getLauncherVersion() {
        return 4.0;
    }

    public static double getVersion(String type) {
        return versions.get(type) == null ? 0.0 : versions.get(type);
    }

    public static String getHash(String type) {
        return fileHashs.get(type) == null ? "" : fileHashs.get(type);
    }

    public static boolean hasVersion(String type) {
        return versions.get(type) != null;
    }

    public static String getURL(String type) {
        return urls.get(type) == null ? "" : urls.get(type);
    }

    public static String getString(String type) {
        return strings.get(type);
    }
}

