/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher;

import java.io.File;

public class WorkingDirectory {
    private static boolean portable;
    private static File workDir;
    private static File launcherDir;
    private static File vanillaWorkDir;

    public static File getWorkingDirectory() {
        if (workDir == null) {
            workDir = WorkingDirectory.getWorkingDirectory("craftland", true);
        }
        return workDir;
    }

    public static File getLauncherDirectory() {
        if (launcherDir == null) {
            launcherDir = new File(".");
        }
        return launcherDir;
    }

    public static File getVanillaWorkingDirectory() {
        if (vanillaWorkDir == null) {
            vanillaWorkDir = WorkingDirectory.getWorkingDirectory("minecraft", false);
        }
        return vanillaWorkDir;
    }

    private static File getWorkingDirectory(String applicationName, boolean makePortable) {
        if (portable && makePortable) {
            if (System.getProperty("craftlandPortable") != null) {
                applicationName = System.getProperty("craftlandPortable");
            }
            File fPortable = new File(applicationName);
            System.setProperty("craftlandPortable", fPortable.getAbsolutePath());
            return fPortable;
        }
        String userHome = System.getProperty("user.home", ".");
        File workingDirectory = switch (WorkingDirectory.getPlatform()) {
            case OS.linux, OS.solaris -> new File(userHome, "." + applicationName + "/");
            case OS.windows -> {
                String applicationData = System.getenv("APPDATA");
                if (applicationData != null) {
                    yield new File(applicationData, "." + applicationName + "/");
                }
                yield new File(userHome, "." + applicationName + "/");
            }
            case OS.macos -> new File(userHome, "Library/Application Support/" + applicationName);
            default -> new File(userHome, applicationName + "/");
        };
        if (!workingDirectory.exists() && !workingDirectory.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + workingDirectory);
        }
        return workingDirectory;
    }

    public static OS getPlatform() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return OS.windows;
        }
        if (osName.contains("mac")) {
            return OS.macos;
        }
        if (osName.contains("solaris")) {
            return OS.solaris;
        }
        if (osName.contains("sunos")) {
            return OS.solaris;
        }
        if (osName.contains("linux")) {
            return OS.linux;
        }
        if (osName.contains("unix")) {
            return OS.linux;
        }
        return OS.unknown;
    }

    public static void setPortable(boolean portable) {
        WorkingDirectory.portable = portable;
        workDir = WorkingDirectory.getWorkingDirectory("craftland", true);
    }

    static {
        workDir = null;
        launcherDir = null;
        vanillaWorkDir = null;
    }

    public static enum OS {
        linux,
        solaris,
        windows,
        macos,
        unknown;

    }
}

