/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher.guifx;

import java.net.MalformedURLException;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.scene.control.Button;
import javafx.scene.text.Text;
import org.craftland.launcher.LoginThread;
import org.craftland.launcher.download.ExtraDownload;
import org.craftland.launcher.guifx.LoginController;

public class DownloadEntry {
    public Text labelDescription;
    public Button buttonDownload;
    private LoginController loginController;
    private ExtraDownload download;

    public void load(LoginController loginController, ExtraDownload download) {
        boolean installed;
        this.loginController = loginController;
        this.download = download;
        double localVersion = download.getLocalVersion();
        boolean bl = installed = localVersion > 0.0;
        if (installed && download.hasUpdate()) {
            this.buttonDownload.setText("Update");
        } else if (installed) {
            this.buttonDownload.setText("Remove");
        } else {
            this.buttonDownload.setText("Install");
        }
        this.labelDescription.setText(download.getDescription());
    }

    public void download(ActionEvent actionEvent) {
        if (this.loginController.getCurrentDownload() == null && this.loginController.getLoginThread() == null) {
            try {
                this.buttonDownload.setDisable(true);
                this.loginController.update(this);
                this.loginController.updateSettings();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void runInstallation(boolean isUpdate, LoginThread loginThread) throws InterruptedException, MalformedURLException {
        if (this.download.hasUpdate()) {
            this.download.remove();
        }
        if (!this.download.isInstalled()) {
            this.download.install(isUpdate, loginThread);
        }
        this.afterInstall();
    }

    private void afterInstall() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (DownloadEntry.this.download.isInstalled()) {
                    DownloadEntry.this.buttonDownload.setText("Remove");
                } else {
                    DownloadEntry.this.buttonDownload.setText("Install");
                }
                DownloadEntry.this.buttonDownload.setDisable(false);
            }
        });
    }

    public ExtraDownload getDownload() {
        return this.download;
    }

    public void runUninstall() {
        if (this.download.isInstalled()) {
            this.download.remove();
        }
        this.afterInstall();
    }

    public void onLoginThreadEnded() {
        this.afterInstall();
    }
}

