/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher.guifx;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.TitledPane;
import javafx.scene.image.ImageView;
import javafx.scene.web.WebView;
import org.apache.commons.text.StringEscapeUtils;
import org.craftland.launcher.guifx.FXUtil;
import org.craftland.launcher.guifx.News;
import org.craftland.util.DesktopUtils;

public class NewsController {
    private static final String LINEBREAK = "\n";

    public static void load(final Accordion accordionNews) {
        Task<Void> task = new Task<Void>(){
            private ArrayList<News> listNews;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void call() throws Exception {
                this.listNews = new ArrayList();
                HttpURLConnection connection = null;
                try (InputStream is = null;){
                    String str;
                    URL url = new URL("http://forum.craftland.org/news_json.php");
                    connection = (HttpURLConnection)url.openConnection();
                    connection.setConnectTimeout(30000);
                    connection.setReadTimeout(30000);
                    connection.connect();
                    if (connection.getResponseCode() / 100 != 2) {
                        throw new IOException("Failed to load " + url + ": " + connection.getResponseCode());
                    }
                    is = connection.getInputStream();
                    InputStreamReader read = new InputStreamReader(is);
                    BufferedReader in = new BufferedReader(read);
                    String date = null;
                    String title = null;
                    String message = null;
                    while ((str = in.readLine()) != null) {
                        if (date == null) {
                            date = str;
                            continue;
                        }
                        if (title == null) {
                            title = str;
                            continue;
                        }
                        if (message == null) {
                            message = str;
                            continue;
                        }
                        if (!str.equals("-")) continue;
                        this.listNews.add(new News(date, title, message));
                        message = null;
                        title = null;
                        date = null;
                    }
                }
                return null;
            }

            protected void succeeded() {
                for (News news : this.listNews) {
                    TitledPane titledPane = new TitledPane(NewsController.wrap(StringEscapeUtils.unescapeHtml4((String)news.getTitle()), 60) + NewsController.LINEBREAK + news.getDate(), NewsController.createCustomContent(news.getMessage()));
                    titledPane.setWrapText(true);
                    ImageView newsIcon = new ImageView(((Object)((Object)this)).getClass().getResource("/img/354_0.png").toExternalForm());
                    titledPane.setGraphic((Node)newsIcon);
                    accordionNews.getPanes().add((Object)titledPane);
                }
                if (accordionNews.getPanes().size() > 0) {
                    accordionNews.setExpandedPane((TitledPane)accordionNews.getPanes().get(0));
                }
            }
        };
        FXUtil.launchTaskAsDaemon(task);
    }

    public static String wrap(String string, int lineLength) {
        StringBuilder b = new StringBuilder();
        for (String line : string.split(Pattern.quote(LINEBREAK))) {
            b.append(NewsController.wrapLine(line, lineLength));
        }
        return b.toString();
    }

    private static String wrapLine(String line, int lineLength) {
        if (line.length() == 0) {
            return "";
        }
        if (line.length() <= lineLength) {
            return line;
        }
        String[] words = line.split(" ");
        StringBuilder allLines = new StringBuilder();
        StringBuilder trimmedLine = new StringBuilder();
        for (String word : words) {
            if (trimmedLine.length() + 1 + word.length() <= lineLength) {
                trimmedLine.append(word).append(" ");
                continue;
            }
            allLines.append((CharSequence)trimmedLine).append(LINEBREAK);
            trimmedLine = new StringBuilder();
            trimmedLine.append(word).append(" ");
        }
        if (trimmedLine.length() > 0) {
            allLines.append((CharSequence)trimmedLine);
        }
        return allLines.toString();
    }

    private static Node createCustomContent(String text) {
        final WebView textArea = new WebView();
        textArea.getEngine().loadContent(text);
        textArea.setFontScale(0.5);
        textArea.setMinHeight(80.0);
        textArea.getEngine().getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldValue, Worker.State newValue) {
                if (newValue == Worker.State.RUNNING) {
                    // empty if block
                }
            }
        });
        textArea.getEngine().locationProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                DesktopUtils.open(newValue);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        textArea.getEngine().getLoadWorker().cancel();
                    }
                });
            }
        });
        return textArea;
    }
}

