/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher.microsoft;

import com.sun.javafx.webkit.WebConsoleListener;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ListChangeListener;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebHistory;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import org.craftland.launcher.microsoft.MicrosoftAccount;
import org.craftland.launcher.microsoft.MicrosoftAuthProcess;

public class MicrosoftAuthWindow
implements Initializable {
    private Stage stage;
    private Runnable callback;
    private MicrosoftAccount account;

    public MicrosoftAccount getAccount() {
        return this.account;
    }

    public void setCallback(Runnable callback) {
        this.callback = callback;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.stage = new Stage();
        this.stage.setTitle("Microsoft Login");
        WebConsoleListener.setDefaultListener((webView, message, lineNumber, sourceId) -> System.out.println(message + "[at " + lineNumber + "]"));
        WebView webView2 = new WebView();
        webView2.getEngine().load("https://login.live.com/oauth20_authorize.srf?client_id=00000000402b5328&response_type=code&scope=service%3A%3Auser.auth.xboxlive.com%3A%3AMBI_SSL&redirect_uri=https%3A%2F%2Flogin.live.com%2Foauth20_desktop.srf");
        webView2.getEngine().setJavaScriptEnabled(true);
        webView2.setPrefHeight(600.0);
        webView2.setPrefWidth(640.0);
        webView2.getEngine().getHistory().getEntries().addListener(this::onHistoryChanged);
        this.stage.setScene(new Scene((Parent)webView2));
        this.stage.show();
    }

    private void onHistoryChanged(ListChangeListener.Change<? extends WebHistory.Entry> c) {
        if (c.next() && c.wasAdded()) {
            for (WebHistory.Entry entry : c.getAddedSubList()) {
                if (!entry.getUrl().startsWith("https://login.live.com/oauth20_desktop.srf?code=")) continue;
                String authCode = entry.getUrl().substring(entry.getUrl().indexOf("=") + 1, entry.getUrl().indexOf("&"));
                this.onGetAuthCode(authCode);
            }
        }
    }

    private void onGetAuthCode(String authCode) {
        System.out.println("authCode: " + authCode);
        MicrosoftAuthProcess microsoftAuthProcess = new MicrosoftAuthProcess();
        microsoftAuthProcess.acquireAccessToken(authCode);
        microsoftAuthProcess.setCallback(() -> Platform.runLater(() -> {
            this.account = microsoftAuthProcess.getAccount();
            this.callback.run();
            this.stage.close();
        }));
    }
}

