/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher.mojang;

import org.craftland.launcher.Launcher;
import org.craftland.launcher.accounts.Account;
import org.craftland.launcher.exception.BadLoginException;
import org.craftland.launcher.mojang.Yggdrasil;
import org.craftland.launcher.mojang.YggdrasilResponseAuth;

public class YggdrasilAccount
extends Account {
    public YggdrasilAccount(YggdrasilResponseAuth value) {
        this.update(value);
    }

    public void update(YggdrasilAccount auth) {
        this.setUserId(auth.id);
        this.setUsername(auth.username);
        this.setValid(auth.valid);
        this.setAccessToken(auth.accessToken);
    }

    public void update(YggdrasilResponseAuth auth) {
        this.setAccessToken(auth.getAccessToken());
        this.setValid(auth.isValid());
        this.setUsername(auth.getUsername());
        this.setUserId(auth.getUserID());
    }

    @Override
    public void refreshToken() throws Exception {
        YggdrasilResponseAuth values = Yggdrasil.doRefresh(this.getAccessToken(), Launcher.getHTTPTimeout());
        if (!values.getUserID().equals(this.getUserID()) || !values.getUsername().equals(this.getUsername())) {
            throw new BadLoginException("Invalid reply: User IDs do not match!");
        }
        this.update(values);
    }
}

