/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher.mojang;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.craftland.launcher.mojang.YggdrasilResponse;

public class YggdrasilResponseAuth
extends YggdrasilResponse {
    private final String id;
    private final String username;
    private String accessToken;
    boolean isValidToken = false;

    public YggdrasilResponseAuth(String id, String username, String accessToken) {
        this.id = id;
        this.username = username;
        this.accessToken = accessToken;
    }

    public YggdrasilResponseAuth(JsonObject responseObj) {
        this.accessToken = responseObj.get("accessToken") != null ? responseObj.get("accessToken").getAsString() : null;
        JsonElement profile = responseObj.get("selectedProfile");
        if (profile != null && this.accessToken != null) {
            JsonObject profileObj = profile.getAsJsonObject();
            this.id = profileObj.get("id").getAsString();
            this.username = profileObj.get("name").getAsString();
            this.isValidToken = true;
        } else {
            this.isValidToken = false;
            this.id = "????";
            this.username = "Invalid profile";
        }
    }

    public boolean isValid() {
        return this.isValidToken;
    }

    public void setValid(boolean isValidToken) {
        this.isValidToken = isValidToken;
    }

    public String getUsername() {
        return this.username;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getUserID() {
        return this.id;
    }

    public void update(YggdrasilResponseAuth response) {
        this.isValidToken = true;
        this.accessToken = response.accessToken;
    }

    public String toString() {
        return this.username;
    }
}

