/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.craftland.launcher.Launcher;
import org.craftland.launcher.LauncherSettings;
import org.craftland.launcher.VersionHandler;
import org.craftland.launcher.WorkingDirectory;
import org.craftland.launcher.download.Download;
import org.craftland.util.UpdateUtils;

public class JVMHelper {
    public static int getVersion() {
        String versionStr = System.getProperty("java.version");
        try {
            String version = versionStr;
            if (version.startsWith("1.")) {
                version = version.substring(2, 3);
            } else {
                int dot = version.indexOf(".");
                if (dot != -1) {
                    version = version.substring(0, dot);
                }
            }
            version = version.replaceAll("[^\\d.]", "");
            return Integer.parseInt(version);
        }
        catch (Exception e) {
            System.err.println("failed parsing java version " + versionStr + " defaulting to 10000");
            return 10000;
        }
    }

    public static boolean getJavaBin(ArrayList<String> params) {
        File f;
        if (LauncherSettings.getInstance().getBoolean("intel_nvidia_gpu_fix", false) && Launcher.is64bit && Launcher.isWindows) {
            File parent = new File("../bin");
            if (System.getProperty("launcher.jredir") != null) {
                File f2;
                parent = f2 = new File(System.getProperty("launcher.jredir"));
            }
            if (!parent.exists()) {
                parent = new File(System.getProperty("java.home"));
            }
            boolean foundDLL = false;
            if (parent.exists()) {
                File f3;
                File f2;
                if (parent.isDirectory() && parent.getName().startsWith("jdk") && !(parent = new File(parent, "jre")).exists()) {
                    parent = parent.getParentFile();
                }
                if (parent.isDirectory() && (f2 = new File(parent, "bin" + File.separator + "server")).isDirectory() && (f3 = new File(f2, "jvm.dll")).isFile()) {
                    foundDLL = true;
                    File loaderFile = new File(WorkingDirectory.getWorkingDirectory(), "JNI.exe");
                    if (!loaderFile.exists() || !UpdateUtils.getFileMD5(loaderFile).equals(VersionHandler.getHash("jni_exe"))) {
                        String loader = VersionHandler.getURL("jni_exe");
                        if (!loader.isEmpty()) {
                            if (loaderFile.exists()) {
                                loaderFile.delete();
                            }
                            try {
                                Download download = new Download(loader, loaderFile.getAbsolutePath());
                                download.load();
                            }
                            catch (Exception e) {
                                JOptionPane.showMessageDialog(null, "Failed downloading JNI.exe\nThe game can still start, but cannot make sure you get the best performance", "An error occured", 0);
                            }
                        } else {
                            System.err.println("Missing URL for JNI.exe");
                        }
                    }
                    if (loaderFile.exists()) {
                        params.add(loaderFile.getAbsolutePath());
                        params.add(f3.getAbsolutePath());
                        return true;
                    }
                    System.err.println("Couldn't locate JNI.exe in " + f2.getAbsolutePath());
                    JOptionPane.showMessageDialog(null, "Couldn't locate JNI.exe in " + f2.getAbsolutePath() + "\n Cannot start JNI.exe (GPU FIX)");
                }
                if (!foundDLL) {
                    JOptionPane.showMessageDialog(null, "Couldn't locate jvm.dll. Cannot start JNI.exe (GPU FIX)");
                }
            }
        }
        if ((f = new File("../bin")).isDirectory() && new File(f, "java").exists()) {
            params.add(f.getAbsolutePath() + File.separator + "java");
            System.out.print("Using java from Craftland Runtime");
            return false;
        }
        if (f.isDirectory() && new File(f, "java.exe").exists()) {
            params.add(f.getAbsolutePath() + File.separator + "java");
            System.out.print("Using java.exe from Craftland Runtime");
            return false;
        }
        params.add("java");
        System.out.print("Using java from path");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJavaVersionResponse(ArrayList<String> params) {
        params.add("-version");
        ProcessBuilder pb = new ProcessBuilder(params).redirectErrorStream(true);
        pb.directory(WorkingDirectory.getWorkingDirectory());
        InputStream stream = null;
        try {
            String firstLine;
            Process p = pb.start();
            stream = p.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            String string = firstLine = reader.readLine();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkMemorySetting(int mem) {
        ArrayList<String> params = new ArrayList<String>();
        File memTestClass = new File(WorkingDirectory.getWorkingDirectory(), "memtest.jar");
        if (!memTestClass.exists() || !UpdateUtils.getFileMD5(memTestClass).equals(VersionHandler.getHash("memtest"))) {
            String loader = VersionHandler.getURL("memtest");
            if (!loader.isEmpty()) {
                if (memTestClass.exists()) {
                    memTestClass.delete();
                }
                try {
                    Download download = new Download(loader, memTestClass.getAbsolutePath());
                    download.load();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Failed downloading memtest.jar\nThe game can still start, but cannot make sure it has enough memory allocated", "An error occured", 0);
                }
            } else {
                System.err.println("Missing URL for memtest.jar");
            }
        }
        JVMHelper.getJavaBin(params);
        params.add("-Xmx" + mem + "m");
        params.add("-cp");
        params.add(memTestClass.getAbsolutePath());
        params.add("TestMemSetting");
        System.out.println("testing memory setting " + params);
        ProcessBuilder pb = new ProcessBuilder(params).redirectErrorStream(true);
        pb.directory(WorkingDirectory.getWorkingDirectory());
        InputStream stream = null;
        Process p = null;
        try {
            p = pb.start();
            stream = p.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            String s = null;
            while ((s = reader.readLine()) != null) {
                System.out.println(s);
                s = s.trim();
                if (s.startsWith("Could not reserve enough space")) {
                    boolean bl = false;
                    return bl;
                }
                if (!s.startsWith("Could not create the Java virtual machine")) continue;
                boolean bl = false;
                return bl;
            }
            long lTimeOut = System.currentTimeMillis() + 10000L;
            int exit = 1;
            while (System.currentTimeMillis() < lTimeOut) {
                try {
                    Thread.sleep(50L);
                    exit = p.exitValue();
                    System.out.println("exit val: " + exit);
                    boolean bl = exit == 0;
                    return bl;
                }
                catch (Exception exception) {
                }
            }
            System.out.println("process timed out");
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = true;
            return bl;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                if (p != null) {
                    try {
                        p.destroy();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

