/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher.assets;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class AssetIndex {
    public static final String DEFAULT_ASSET_NAME = "legacy";
    private final Map<String, AssetObject> objects = new LinkedHashMap<String, AssetObject>();
    private boolean map_to_resources;

    public Map<String, AssetObject> getFileMap() {
        return this.objects;
    }

    public Map<AssetObject, String> getUniqueObjects() {
        HashMap<AssetObject, String> result = new HashMap<AssetObject, String>();
        for (Map.Entry<String, AssetObject> objectEntry : this.objects.entrySet()) {
            result.put(objectEntry.getValue(), objectEntry.getKey());
        }
        return result;
    }

    public boolean isVirtual() {
        return this.map_to_resources;
    }

    public class AssetObject {
        private String hash;
        private long size;
        private boolean reconstruct;
        private String compressedHash;
        private long compressedSize;

        public String getHash() {
            return this.hash;
        }

        public long getSize() {
            return this.size;
        }

        public boolean shouldReconstruct() {
            return this.reconstruct;
        }

        public boolean hasCompressedAlternative() {
            return this.compressedHash != null;
        }

        public String getCompressedHash() {
            return this.compressedHash;
        }

        public long getCompressedSize() {
            return this.compressedSize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o != null && this.getClass() == o.getClass()) {
                AssetObject that = (AssetObject)o;
                if (this.compressedSize != that.compressedSize) {
                    return false;
                }
                if (this.reconstruct != that.reconstruct) {
                    return false;
                }
                if (this.size != that.size) {
                    return false;
                }
                if (!(this.compressedHash != null ? this.compressedHash.equals(that.compressedHash) : that.compressedHash == null)) {
                    return false;
                }
                return !(this.hash != null ? !this.hash.equals(that.hash) : that.hash != null);
            }
            return false;
        }

        public int hashCode() {
            int result = this.hash != null ? this.hash.hashCode() : 0;
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            result = 31 * result + (this.reconstruct ? 1 : 0);
            result = 31 * result + (this.compressedHash != null ? this.compressedHash.hashCode() : 0);
            result = 31 * result + (int)(this.compressedSize ^ this.compressedSize >>> 32);
            return result;
        }
    }
}

