/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher.assets;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.craftland.launcher.WorkingDirectory;
import org.craftland.launcher.assets.AssetDownloadable;
import org.craftland.launcher.assets.AssetIndex;
import org.craftland.launcher.assets.DateTypeAdapter;
import org.craftland.launcher.assets.Downloadable;
import org.craftland.launcher.assets.VersionInfo;

public class AssetLoader {
    private static final Charset ENCODING = Charset.forName("UTF-8");
    private static final String versionJsonURL = "https://launchermeta.mojang.com/mc/game/version_manifest.json";
    private String mcAssetVersion;
    private String localFilename;
    private final Gson gson = new Gson();

    public AssetLoader(String mcVersion, String localFilename) {
        this.mcAssetVersion = mcVersion;
        this.localFilename = localFilename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<Downloadable> load() {
        HashSet<Downloadable> result = new HashSet<Downloadable>();
        InputStream inputStream = null;
        File assets = new File(WorkingDirectory.getWorkingDirectory(), "assets");
        File objectsFolder = new File(assets, "objects");
        File indexesFolder = new File(assets, "indexes");
        long start = System.nanoTime();
        try {
            URL ex = this.fetchAssetUrl(this.mcAssetVersion);
            inputStream = ex.openConnection().getInputStream();
            File indexFile = new File(indexesFolder, this.localFilename + ".json");
            String json = IOUtils.toString((InputStream)inputStream, (Charset)ENCODING);
            FileUtils.writeStringToFile((File)indexFile, (String)json, (Charset)ENCODING);
            AssetIndex index = (AssetIndex)this.gson.fromJson(json, AssetIndex.class);
            Map<AssetIndex.AssetObject, String> m = index.getUniqueObjects();
            for (Map.Entry<AssetIndex.AssetObject, String> entry : m.entrySet()) {
                AssetIndex.AssetObject delta = entry.getKey();
                String filename = delta.getHash().substring(0, 2) + "/" + delta.getHash();
                File file = new File(objectsFolder, filename);
                if (file.isFile() && FileUtils.sizeOf((File)file) == delta.getSize()) continue;
                AssetDownloadable downloadable = new AssetDownloadable(Proxy.NO_PROXY, entry.getValue(), delta, "http://resources.download.minecraft.net/", objectsFolder);
                downloadable.setExpectedSize(delta.getSize());
                result.add(downloadable);
            }
            long end1 = System.nanoTime();
            long delta1 = end1 - start;
            System.err.println("Delta time to compare resources: " + delta1 / 1000000L + " ms ");
        }
        catch (Exception var25) {
            try {
                System.err.println("Couldn't download resources");
                var25.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return result;
    }

    private URL fetchAssetUrl(String mcAssetVersion) throws IOException {
        VersionInfo versionInfo = (VersionInfo)this.gson.fromJson(IOUtils.toString((URL)new URL(versionJsonURL), (Charset)ENCODING), VersionInfo.class);
        VersionInfo.Version version = versionInfo.getVersion(mcAssetVersion);
        JsonParser parser = new JsonParser();
        JsonObject versionObject = parser.parse(IOUtils.toString((URL)new URL(version.getUrl()), (Charset)ENCODING)).getAsJsonObject();
        JsonObject assetIndex = versionObject.getAsJsonObject("assetIndex");
        return new URL(assetIndex.get("url").getAsString());
    }

    public File reconstructAssets(File virtualRoot) throws IOException {
        File assetsDir = new File(WorkingDirectory.getWorkingDirectory(), "assets");
        File indexDir = new File(assetsDir, "indexes");
        File objectDir = new File(assetsDir, "objects");
        File indexFile = new File(indexDir, this.localFilename + ".json");
        if (!indexFile.isFile()) {
            System.err.println("No assets index file " + virtualRoot + "; can't reconstruct assets");
            return virtualRoot;
        }
        AssetIndex index = (AssetIndex)this.gson.fromJson(FileUtils.readFileToString((File)indexFile, (Charset)ENCODING), AssetIndex.class);
        System.err.println("Reconstructing virtual assets folder at " + virtualRoot.getAbsolutePath());
        for (Map.Entry<String, AssetIndex.AssetObject> entry : index.getFileMap().entrySet()) {
            File target = new File(virtualRoot, entry.getKey());
            File original = new File(new File(objectDir, entry.getValue().getHash().substring(0, 2)), entry.getValue().getHash());
            if (target.isFile()) continue;
            FileUtils.copyFile((File)original, (File)target, (boolean)false);
        }
        FileUtils.writeStringToFile((File)new File(virtualRoot, ".lastused"), (String)new DateTypeAdapter().serializeToString(new Date()), (Charset)ENCODING);
        return virtualRoot;
    }
}

