/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher.accounts;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.craftland.launcher.WorkingDirectory;
import org.craftland.launcher.accounts.Account;
import org.craftland.launcher.accounts.OldAccounts;
import org.craftland.launcher.accounts.RuntimeTypeAdapterFactory;
import org.craftland.launcher.microsoft.MicrosoftAccount;
import org.craftland.launcher.mojang.YggdrasilAccount;
import org.craftland.launcher.mojang.YggdrasilResponseAuth;

public class Accounts {
    private static final Accounts instance = new Accounts();
    private LinkedHashMap<String, Account> accounts = new LinkedHashMap();
    private ObservableList<Account> list = FXCollections.observableArrayList();
    private Gson gson;

    public static Accounts getInstance() {
        return instance;
    }

    public Accounts() {
        RuntimeTypeAdapterFactory<MicrosoftAccount> accountAdapter = RuntimeTypeAdapterFactory.of(Account.class, "type").registerSubtype(YggdrasilAccount.class, "YggdrasilAccount").registerSubtype(MicrosoftAccount.class, "MicrosoftAccount");
        this.gson = new GsonBuilder().registerTypeAdapterFactory(accountAdapter).setPrettyPrinting().create();
    }

    public void write() {
        block6: {
            try {
                File accountsFile = new File(WorkingDirectory.getWorkingDirectory(), "accounts.json");
                if (accountsFile.exists() && !accountsFile.canWrite()) break block6;
                try (BufferedWriter wr = null;){
                    wr = new BufferedWriter(new FileWriter(accountsFile));
                    this.gson.toJson(new HashMap<String, Account>(this.accounts), new TypeToken<Map<String, Account>>(){}.getType(), (Appendable)wr);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void load() throws FileNotFoundException {
        File accountsFile = new File(WorkingDirectory.getWorkingDirectory(), "accounts.json");
        if (accountsFile.isFile()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(accountsFile));
                Map accs = (Map)this.gson.fromJson((Reader)reader, new TypeToken<Map<String, Account>>(){}.getType());
                if (accs != null) {
                    for (Map.Entry entry : accs.entrySet()) {
                        Account value = (Account)entry.getValue();
                        if (value.getUserID() == null) continue;
                        this.accounts.put((String)entry.getKey(), value);
                    }
                }
                this.list.clear();
                this.list.addAll(this.accounts.values());
                reader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    reader = new BufferedReader(new FileReader(accountsFile));
                    OldAccounts accs = (OldAccounts)new Gson().fromJson((Reader)reader, OldAccounts.class);
                    if (accs != null) {
                        for (Map.Entry<String, YggdrasilResponseAuth> entry : accs.accounts.entrySet()) {
                            YggdrasilResponseAuth value = entry.getValue();
                            if (value.getUserID() == null) continue;
                            this.accounts.put(entry.getKey(), new YggdrasilAccount(value));
                        }
                    }
                    this.list.clear();
                    this.list.addAll(this.accounts.values());
                    reader.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void putOrUpdate(Account auth) {
        this.removeID(auth.getUserID());
        Account old = this.accounts.put(auth.getUserID(), auth);
        this.list.clear();
        this.list.addAll(this.accounts.values());
        this.write();
    }

    public void removeID(String userID) {
        this.accounts.values().removeIf(auth -> userID.equals(auth.getUserID()));
        this.list.clear();
        this.list.addAll(this.accounts.values());
        this.write();
    }

    public Account getAccountID(String userID) {
        for (Account auth : this.accounts.values()) {
            if (!userID.equals(auth.getUserID())) continue;
            return auth;
        }
        return null;
    }

    public ObservableList<Account> getAccounts() {
        return this.list;
    }

    public String getAccountName(int i) {
        ArrayList<String> l = new ArrayList<String>(this.accounts.keySet());
        if (i >= l.size()) {
            return null;
        }
        return l.get(i);
    }

    public void reorder(int arg1, int arg2) {
        try {
            Account movedFrom;
            if (this.accounts.size() > 1 && (movedFrom = this.getModelItem(arg1)) != null) {
                LinkedHashMap<String, Account> accounts = new LinkedHashMap<String, Account>();
                Iterator<Map.Entry<String, Account>> it = this.accounts.entrySet().iterator();
                int idx = 0;
                while (it.hasNext()) {
                    Map.Entry<String, Account> entry = it.next();
                    if (movedFrom != null && idx == arg2) {
                        accounts.put(movedFrom.getUserID(), movedFrom);
                        movedFrom = null;
                        ++idx;
                    }
                    if (entry.getValue() == movedFrom) continue;
                    accounts.put(entry.getKey(), entry.getValue());
                    ++idx;
                }
                if (movedFrom != null) {
                    accounts.put(movedFrom.getUserID(), movedFrom);
                }
                this.accounts = accounts;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.write();
    }

    public Account getModelItem(int index) {
        ArrayList<String> l = new ArrayList<String>(this.accounts.keySet());
        if (index >= l.size()) {
            return null;
        }
        return this.accounts.get(l.get(index));
    }

    public int getItemCount() {
        return this.accounts.size();
    }
}

