/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher.accounts;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataListener;
import org.craftland.launcher.WorkingDirectory;
import org.craftland.launcher.mojang.YggdrasilResponseAuth;

public class OldAccounts
implements ComboBoxModel {
    static final OldAccounts instance = new OldAccounts();
    LinkedHashMap<String, YggdrasilResponseAuth> accounts = new LinkedHashMap();
    private String selected;

    public static OldAccounts getInstance() {
        return instance;
    }

    public void write() {
        block6: {
            try {
                File accountsFile = new File(WorkingDirectory.getWorkingDirectory(), "accounts.json");
                if (accountsFile.exists() && !accountsFile.canWrite()) break block6;
                try (BufferedWriter wr = null;){
                    wr = new BufferedWriter(new FileWriter(accountsFile));
                    new GsonBuilder().setPrettyPrinting().create().toJson((Object)this, (Appendable)wr);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void load() throws FileNotFoundException {
        File accountsFile = new File(WorkingDirectory.getWorkingDirectory(), "accounts.json");
        if (accountsFile.isFile()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(accountsFile));
                OldAccounts accs = (OldAccounts)new Gson().fromJson((Reader)reader, OldAccounts.class);
                if (accs != null) {
                    this.accounts = accs.accounts;
                    if (!this.accounts.isEmpty()) {
                        this.selected = ((YggdrasilResponseAuth)this.getElementAt(0)).getUserID();
                    }
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void putOrUpdate(YggdrasilResponseAuth auth) {
        YggdrasilResponseAuth old = this.accounts.put(auth.getUserID(), auth);
        if (old != null) {
            old.update(auth);
        }
        this.write();
    }

    public void removeID(String userID) {
        Iterator<YggdrasilResponseAuth> it = this.accounts.values().iterator();
        while (it.hasNext()) {
            YggdrasilResponseAuth auth = it.next();
            if (!userID.equals(auth.getUserID())) continue;
            it.remove();
        }
        this.write();
    }

    public YggdrasilResponseAuth getAccountID(String userID) {
        for (YggdrasilResponseAuth auth : this.accounts.values()) {
            if (!userID.equals(auth.getUserID())) continue;
            return auth;
        }
        return null;
    }

    public Collection<YggdrasilResponseAuth> getAccounts() {
        return this.accounts.values();
    }

    public YggdrasilResponseAuth getAccount(String name) {
        for (YggdrasilResponseAuth auth : this.accounts.values()) {
            if (!name.equals(auth.getUsername())) continue;
            return auth;
        }
        return null;
    }

    @Override
    public void addListDataListener(ListDataListener arg0) {
    }

    @Override
    public Object getElementAt(int arg0) {
        ArrayList<String> l = new ArrayList<String>(this.accounts.keySet());
        if (arg0 >= l.size()) {
            return null;
        }
        return this.accounts.get(l.get(arg0));
    }

    public String getAccountName(int i) {
        ArrayList<String> l = new ArrayList<String>(this.accounts.keySet());
        if (i >= l.size()) {
            return null;
        }
        return l.get(i);
    }

    @Override
    public int getSize() {
        return this.accounts.size();
    }

    @Override
    public void removeListDataListener(ListDataListener arg0) {
    }

    @Override
    public Object getSelectedItem() {
        if (this.selected == null && !this.accounts.isEmpty()) {
            for (YggdrasilResponseAuth a : this.accounts.values()) {
                if (!a.isValid()) continue;
                this.selected = a.getUserID();
            }
            if (this.selected == null) {
                this.selected = this.accounts.values().iterator().next().getUserID();
            }
        }
        return this.selected == null || this.accounts.isEmpty() ? null : this.accounts.get(this.selected);
    }

    @Override
    public void setSelectedItem(Object arg0) {
        this.selected = ((YggdrasilResponseAuth)arg0).getUserID();
    }

    public void reorder(int arg1, int arg2) {
        try {
            YggdrasilResponseAuth movedFrom;
            if (this.accounts.size() > 1 && (movedFrom = (YggdrasilResponseAuth)this.getElementAt(arg1)) != null) {
                LinkedHashMap<String, YggdrasilResponseAuth> accounts = new LinkedHashMap<String, YggdrasilResponseAuth>();
                Iterator<Map.Entry<String, YggdrasilResponseAuth>> it = this.accounts.entrySet().iterator();
                int idx = 0;
                while (it.hasNext()) {
                    Map.Entry<String, YggdrasilResponseAuth> entry = it.next();
                    if (movedFrom != null && idx == arg2) {
                        accounts.put(movedFrom.getUserID(), movedFrom);
                        movedFrom = null;
                        ++idx;
                    }
                    if (entry.getValue() == movedFrom) continue;
                    accounts.put(entry.getKey(), entry.getValue());
                    ++idx;
                }
                if (movedFrom != null) {
                    accounts.put(movedFrom.getUserID(), movedFrom);
                }
                this.accounts = accounts;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.write();
    }
}

