/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher.microsoft;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.craftland.launcher.microsoft.MicrosoftAccount;

public class MicrosoftAuthProcess {
    public static final String loginUrl = "https://login.live.com/oauth20_authorize.srf?client_id=00000000402b5328&response_type=code&scope=service%3A%3Auser.auth.xboxlive.com%3A%3AMBI_SSL&redirect_uri=https%3A%2F%2Flogin.live.com%2Foauth20_desktop.srf";
    public static final String redirectUrlSuffix = "https://login.live.com/oauth20_desktop.srf?code=";
    private static final String authTokenUrl = "https://login.live.com/oauth20_token.srf";
    private static final String xblAuthUrl = "https://user.auth.xboxlive.com/user/authenticate";
    private static final String xstsAuthUrl = "https://xsts.auth.xboxlive.com/xsts/authorize";
    private static final String mcLoginUrl = "https://api.minecraftservices.com/authentication/login_with_xbox";
    private static final String mcStoreUrl = "https://api.minecraftservices.com/entitlements/mcstore";
    private static final String mcProfileUrl = "https://api.minecraftservices.com/minecraft/profile";
    private JsonObject profile;
    private String authCode;
    private String accessToken;
    private String refreshToken;
    private String mcAccessToken;
    private String error;
    private Throwable exception;
    private String username;
    private String uuid;
    private Runnable callback;

    public void acquireAccessToken(String authcode) {
        this.authCode = authcode;
        try {
            URI uri = new URI(authTokenUrl);
            Map<Object, Object> data = Map.of("client_id", "00000000402b5328", "code", authcode, "grant_type", "authorization_code", "redirect_uri", "https://login.live.com/oauth20_desktop.srf", "scope", "service::user.auth.xboxlive.com::MBI_SSL");
            HttpRequest request = HttpRequest.newBuilder(uri).header("Content-Type", "application/x-www-form-urlencoded").POST(MicrosoftAuthProcess.ofFormData(data)).build();
            HttpClient.newBuilder().build().sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAccept(resp -> {
                if (resp.statusCode() >= 200 && resp.statusCode() < 300) {
                    String body = (String)resp.body();
                    try {
                        JsonObject jsonObject = new JsonParser().parse(body).getAsJsonObject();
                        this.accessToken = jsonObject.get("access_token").getAsString();
                        this.refreshToken = jsonObject.get("refresh_token").getAsString();
                        System.out.println("accessToken: " + this.accessToken);
                        this.acquireXBLToken(this.accessToken);
                    }
                    catch (JsonSyntaxException e) {
                        this.handleException(e);
                    }
                }
            });
        }
        catch (URISyntaxException e) {
            this.handleException(e);
        }
    }

    public void refreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        try {
            URI uri = new URI(authTokenUrl);
            Map<Object, Object> data = Map.of("client_id", "00000000402b5328", "refresh_token", refreshToken, "grant_type", "refresh_token", "redirect_uri", "https://login.live.com/oauth20_desktop.srf", "scope", "service::user.auth.xboxlive.com::MBI_SSL");
            HttpRequest request = HttpRequest.newBuilder(uri).header("Content-Type", "application/x-www-form-urlencoded").POST(MicrosoftAuthProcess.ofFormData(data)).build();
            HttpClient.newBuilder().build().sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAccept(resp -> {
                if (resp.statusCode() >= 200 && resp.statusCode() < 300) {
                    String body = (String)resp.body();
                    try {
                        JsonObject jsonObject = new JsonParser().parse(body).getAsJsonObject();
                        this.accessToken = jsonObject.get("access_token").getAsString();
                        this.refreshToken = jsonObject.get("refresh_token").getAsString();
                        System.out.println("accessToken: " + this.accessToken);
                        this.acquireXBLToken(this.accessToken);
                    }
                    catch (JsonSyntaxException e) {
                        this.handleException(e);
                    }
                }
            });
        }
        catch (URISyntaxException e) {
            this.handleException(e);
        }
    }

    private void acquireXBLToken(String accessToken) {
        try {
            URI uri = new URI(xblAuthUrl);
            Map<Object, Object> data = Map.of("Properties", Map.of("AuthMethod", "RPS", "SiteName", "user.auth.xboxlive.com", "RpsTicket", accessToken), "RelyingParty", "http://auth.xboxlive.com", "TokenType", "JWT");
            HttpRequest request = HttpRequest.newBuilder(uri).header("Content-Type", "application/json").header("Accept", "application/json").POST(MicrosoftAuthProcess.ofJSONData(data)).build();
            HttpClient.newBuilder().build().sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAccept(resp -> {
                if (resp.statusCode() >= 200 && resp.statusCode() < 300) {
                    String body = (String)resp.body();
                    try {
                        JsonObject jsonObject = new JsonParser().parse(body).getAsJsonObject();
                        String xblToken = jsonObject.get("Token").getAsString();
                        System.out.println("xblToken: " + xblToken);
                        this.acquireXsts(xblToken);
                    }
                    catch (JsonSyntaxException e) {
                        this.handleException(e);
                    }
                } else {
                    this.handleHttpError((HttpResponse<String>)resp);
                }
            });
        }
        catch (URISyntaxException e) {
            this.handleException(e);
        }
    }

    private void acquireXsts(String xblToken) {
        try {
            URI uri = new URI(xstsAuthUrl);
            Map<Object, Object> data = Map.of("Properties", Map.of("SandboxId", "RETAIL", "UserTokens", List.of(xblToken)), "RelyingParty", "rp://api.minecraftservices.com/", "TokenType", "JWT");
            HttpRequest request = HttpRequest.newBuilder(uri).header("Content-Type", "application/json").header("Accept", "application/json").POST(MicrosoftAuthProcess.ofJSONData(data)).build();
            HttpClient.newBuilder().build().sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAccept(resp -> {
                if (resp.statusCode() >= 200 && resp.statusCode() < 300) {
                    String body = (String)resp.body();
                    try {
                        JsonObject jsonObject = new JsonParser().parse(body).getAsJsonObject();
                        String xblXsts = jsonObject.get("Token").getAsString();
                        JsonObject claims = jsonObject.get("DisplayClaims").getAsJsonObject();
                        JsonArray xui = claims.get("xui").getAsJsonArray();
                        String uhs = ((JsonObject)xui.get(0)).get("uhs").getAsString();
                        System.out.println("xblXsts: " + xblXsts + ", uhs: " + uhs);
                        this.acquireMinecraftToken(uhs, xblXsts);
                    }
                    catch (JsonSyntaxException e) {
                        this.handleException(e);
                    }
                } else {
                    this.handleHttpError((HttpResponse<String>)resp);
                }
            });
        }
        catch (URISyntaxException e) {
            this.handleException(e);
        }
    }

    private void acquireMinecraftToken(String xblUhs, String xblXsts) {
        try {
            URI uri = new URI(mcLoginUrl);
            Map<Object, Object> data = Map.of("identityToken", "XBL3.0 x=" + xblUhs + ";" + xblXsts);
            HttpRequest request = HttpRequest.newBuilder(uri).header("Content-Type", "application/json").header("Accept", "application/json").POST(MicrosoftAuthProcess.ofJSONData(data)).build();
            HttpClient.newBuilder().build().sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAccept(resp -> {
                if (resp.statusCode() >= 200 && resp.statusCode() < 300) {
                    String body = (String)resp.body();
                    try {
                        JsonObject jsonObject = new JsonParser().parse(body).getAsJsonObject();
                        String mcAccessToken = jsonObject.get("access_token").getAsString();
                        System.out.println("mcAccessToken: " + mcAccessToken);
                        this.setMcAccessToken(mcAccessToken);
                        this.checkMcProfile(mcAccessToken);
                    }
                    catch (JsonSyntaxException e) {
                        this.handleException(e);
                    }
                } else {
                    this.handleHttpError((HttpResponse<String>)resp);
                }
            });
        }
        catch (URISyntaxException e) {
            this.handleException(e);
        }
    }

    private void checkMcStore(String mcAccessToken) {
        try {
            URI uri = new URI(mcStoreUrl);
            HttpRequest request = HttpRequest.newBuilder(uri).header("Authorization", "Bearer " + mcAccessToken).GET().build();
            HttpClient.newBuilder().build().sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAccept(resp -> {
                if (resp.statusCode() >= 200 && resp.statusCode() < 300) {
                    String body = (String)resp.body();
                    System.out.println("store: " + body);
                } else {
                    this.handleHttpError((HttpResponse<String>)resp);
                }
            });
        }
        catch (URISyntaxException e) {
            this.handleException(e);
        }
    }

    private void handleHttpError(HttpResponse<String> resp) {
        System.err.println("Bad Http Response: " + resp.statusCode());
        Thread.dumpStack();
        this.error = "Bad Http Response: " + resp.statusCode();
        this.callback.run();
    }

    private void checkMcProfile(String mcAccessToken) {
        try {
            URI uri = new URI(mcProfileUrl);
            HttpRequest request = HttpRequest.newBuilder(uri).header("Authorization", "Bearer " + mcAccessToken).GET().build();
            HttpClient.newBuilder().build().sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAccept(resp -> {
                if (resp.statusCode() >= 200 && resp.statusCode() < 300) {
                    String body = (String)resp.body();
                    try {
                        System.out.println("profile:" + body);
                        JsonObject jsonObject = new JsonParser().parse(body).getAsJsonObject();
                        this.username = jsonObject.get("name").getAsString();
                        this.uuid = jsonObject.get("id").getAsString();
                        String uuidDashes = this.uuid.replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5");
                        this.profile = jsonObject;
                        this.callback.run();
                    }
                    catch (JsonSyntaxException e) {
                        this.handleException(e);
                    }
                } else {
                    String body = (String)resp.body();
                    System.out.println("profile: " + resp.statusCode() + ": " + body);
                    this.error = "This microsoft account does not own Minecraft.";
                }
            });
        }
        catch (URISyntaxException e) {
            this.handleException(e);
        }
    }

    private void handleException(Throwable e) {
        e.printStackTrace();
        this.exception = e;
        this.error = e.getMessage();
        this.callback.run();
    }

    public static HttpRequest.BodyPublisher ofJSONData(Map<Object, Object> data) {
        return HttpRequest.BodyPublishers.ofString(new Gson().toJson(data));
    }

    public static HttpRequest.BodyPublisher ofFormData(Map<Object, Object> data) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Object, Object> entry : data.entrySet()) {
            if (builder.length() > 0) {
                builder.append("&");
            }
            builder.append(URLEncoder.encode(entry.getKey().toString(), StandardCharsets.UTF_8));
            builder.append("=");
            builder.append(URLEncoder.encode(entry.getValue().toString(), StandardCharsets.UTF_8));
        }
        return HttpRequest.BodyPublishers.ofString(builder.toString());
    }

    public void setMcAccessToken(String mcAccessToken) {
        this.mcAccessToken = mcAccessToken;
    }

    public MicrosoftAccount getAccount() {
        MicrosoftAccount account = new MicrosoftAccount();
        account.setUserId(this.uuid);
        account.setUsername(this.username);
        account.setAuthCode(this.authCode);
        account.setRefreshToken(this.refreshToken);
        account.setAccessToken(this.mcAccessToken);
        account.setValid(this.profile != null);
        return account;
    }

    public void setCallback(Runnable runnable) {
        this.callback = runnable;
    }
}

