/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher.updater;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.craftland.launcher.LoginState;
import org.craftland.launcher.LoginThread;
import org.craftland.launcher.VersionHandler;
import org.craftland.launcher.WorkingDirectory;
import org.craftland.launcher.exception.UpdateFailedException;
import org.craftland.launcher.updater.GameUpdater;
import org.craftland.util.UpdateUtils;

public class UpdateFile {
    String name;
    String fileLocationLocal;
    private final String versionLocationLocal;
    private Double localVersion;
    ArrayList<String> filesToSkip = new ArrayList();
    private String in = null;
    private String out = null;
    static final int BUFFERSIZE = 16384;

    public UpdateFile(String name, String[] strings) {
        this.name = name;
        if (strings != null) {
            for (String s : strings) {
                this.filesToSkip.add(s);
            }
        }
        this.fileLocationLocal = GameUpdater.updateDir + File.separator + name + ".zip";
        this.versionLocationLocal = WorkingDirectory.getWorkingDirectory().getPath() + File.separator + "version_" + name + ".txt";
    }

    public void update(GameUpdater gu, LoginThread loginThread) throws Exception {
        loginThread.setLoginState(LoginState.UPDATING_MOD, "Checking versions");
        this.loadVersions();
        loginThread.setLoginState(LoginState.UPDATING_MOD, "Loading files");
        this.download(gu, loginThread);
        loginThread.setLoginState(LoginState.UPDATING_MOD, "Extracting files");
        this.extract(loginThread);
    }

    public void deleteVersion() {
        File versionFile = new File(this.versionLocationLocal);
        if (versionFile.exists()) {
            versionFile.delete();
        }
        this.localVersion = null;
    }

    protected boolean skipFile(String entry) {
        for (String skipName : this.filesToSkip) {
            if (!entry.startsWith(skipName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extract(LoginThread loginThread) throws IOException, UpdateFailedException {
        File modFile = new File(this.fileLocationLocal);
        loginThread.setLoginState(LoginState.UPDATING_MOD, "Unzipping " + modFile);
        try (FileInputStream fis = null;){
            fis = new FileInputStream(modFile);
            ZipFile zip = null;
            InputStream lastZipIs = null;
            int i = 0;
            try {
                zip = new ZipFile(modFile);
                Enumeration zipEntries = zip.getEntries();
                byte[] data = new byte[16384];
                while (zipEntries.hasMoreElements()) {
                    ZipArchiveEntry entry = (ZipArchiveEntry)zipEntries.nextElement();
                    if (entry.isDirectory() || this.skipFile(entry.getName())) continue;
                    File writeTo = null;
                    if (entry.getName().startsWith("Resources")) {
                        writeTo = new File(GameUpdater.resourcesDir.getPath() + File.separator + entry.getName().replaceFirst("Resources", ""));
                    } else {
                        if (entry.getName().startsWith("Jar")) continue;
                        if (entry.getName().startsWith("bin")) {
                            writeTo = new File(WorkingDirectory.getWorkingDirectory().getPath() + File.separator + entry.getName());
                        }
                    }
                    if (writeTo == null) continue;
                    if (this.in != null && this.out != null && writeTo.getName().equals(this.in)) {
                        File newFile = new File(writeTo.getParentFile(), this.out);
                        System.out.println("Rewriting " + writeTo + " -> " + newFile);
                        writeTo = newFile;
                    }
                    writeTo.getParentFile().mkdirs();
                    if (i++ % 4 == 0) {
                        loginThread.setLoginState(LoginState.UPDATING_MOD, "Unzipping " + entry.getName());
                    }
                    if (!zip.canReadEntryData(entry)) {
                        String updateURL = VersionHandler.getURL(this.name);
                        throw new UpdateFailedException("Invalid zip file: " + modFile, new Exception("Expected non-empty zip file loaded from " + updateURL), true);
                    }
                    lastZipIs = zip.getInputStream(entry);
                    try (FileOutputStream fos = null;){
                        fos = new FileOutputStream(writeTo);
                        BufferedOutputStream dest = new BufferedOutputStream(fos, 16384);
                        int count = 0;
                        while ((count = lastZipIs.read(data, 0, 16384)) != -1) {
                            dest.write(data, 0, count);
                        }
                        dest.flush();
                    }
                    lastZipIs.close();
                }
            }
            catch (ZipException zex) {
                String updateURL = VersionHandler.getURL(this.name);
                throw new UpdateFailedException("Invalid zip file: " + modFile, new Exception("Loaded invalid zip-file from " + updateURL), true);
            }
            finally {
                if (zip != null) {
                    zip.close();
                }
                if (lastZipIs != null) {
                    lastZipIs.close();
                }
            }
            if (i == 0) {
                System.err.println("Did not extract any files from " + modFile);
            }
        }
    }

    public void download(GameUpdater gu, LoginThread loginThread) throws Exception {
        String updateURL;
        File to = new File(this.fileLocationLocal);
        if (to.exists()) {
            String hash = VersionHandler.getHash(this.name);
            String localHash = UpdateUtils.getFileMD5(to);
            if (localHash != null && localHash.equals(hash)) {
                System.out.println("skipping download of " + this.name + ". Local hash matches remote");
                return;
            }
            System.err.println(this.name + ": hash mismatch. Local: " + localHash + ", Remote: " + hash);
        }
        if ((updateURL = this.getURL()) == null || updateURL.isEmpty()) {
            throw new Exception("Did not find URL for " + this.name + " download");
        }
        long lTook = System.currentTimeMillis();
        gu.downloadFile(updateURL, this.fileLocationLocal, loginThread);
        String hash = VersionHandler.getHash(this.name);
        String localHash = UpdateUtils.getFileMD5(to);
        if (localHash == null || localHash.equals(hash)) {
            System.out.println("successful download of " + this.name + ". Local hash:" + localHash + ", remote: " + hash + ". matches remote");
            return;
        }
        System.err.println(this.name + ": hash mismatch. Local: " + localHash + ", Remote: " + hash + ". Downloading one more time");
        gu.downloadFile(updateURL, this.fileLocationLocal, loginThread);
        if ((lTook -= System.currentTimeMillis()) < 720000L) {
            hash = VersionHandler.getHash(this.name);
            localHash = UpdateUtils.getFileMD5(to);
            if (localHash != null && !localHash.equals(hash)) {
                System.err.println(this.name + ": hash still not matching. Local: " + localHash + ", Remote: " + hash + ". Downloading a third time");
                gu.downloadFile(updateURL, this.fileLocationLocal, loginThread);
            } else {
                System.out.println("successful download of " + this.name + ". Local hash:" + localHash + ", remote: " + hash + ". matches remote");
            }
        }
    }

    protected String getURL() {
        return VersionHandler.getURL(this.name);
    }

    public boolean needsUpdate() throws Exception {
        if (this.localVersion == null) {
            this.loadVersions();
        }
        return this.localVersion == null || this.localVersion.doubleValue() != this.getRemoteVersion();
    }

    public double getLocalVersion() throws Exception {
        if (this.localVersion == null) {
            this.loadVersions();
        }
        return this.localVersion == null ? 0.0 : this.localVersion;
    }

    public double getRemoteVersion() {
        return VersionHandler.getVersion(this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadVersions() throws Exception {
        File localVersionFile = new File(this.versionLocationLocal);
        if (!localVersionFile.exists()) {
            localVersionFile.getParentFile().mkdirs();
        } else {
            try (FileReader fr = null;){
                fr = new FileReader(localVersionFile);
                BufferedReader br = new BufferedReader(fr);
                String line = br.readLine();
                if (line != null) {
                    this.localVersion = Double.parseDouble(line);
                }
            }
        }
    }

    public boolean isFirstUpdate() {
        return this.localVersion == null;
    }

    public void updateLocalVersion() throws IOException {
        this.localVersion = this.getRemoteVersion();
        File writeVersionTo = new File(this.versionLocationLocal);
        if (writeVersionTo.exists()) {
            writeVersionTo.delete();
        } else {
            writeVersionTo.getParentFile().mkdirs();
        }
        UpdateUtils.writeTextFile(writeVersionTo, String.valueOf(this.localVersion));
    }

    public UpdateFile rewriteOutput(String string, String string2) {
        this.in = string;
        this.out = string2;
        return this;
    }
}

