/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.util;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.io.Charsets;
import org.craftland.launcher.exception.MCNetworkException;
import org.craftland.util.HTTPReply;

public class HTTPPost {
    public static HTTPReply excutePost(String targetURL, String urlParameters, String contentType, int timeOut) throws IOException, MCNetworkException {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(targetURL);
            connection = (HttpsURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", contentType + "; charset=utf-8");
            connection.setRequestProperty("Content-Length", Integer.toString(urlParameters.getBytes().length));
            if (timeOut == 0) {
                timeOut = 12000;
            }
            if (timeOut > 0) {
                connection.setConnectTimeout(timeOut);
                connection.setReadTimeout(timeOut);
            }
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.connect();
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            byte[] postAsBytes = urlParameters.getBytes(Charsets.UTF_8);
            wr.write(postAsBytes);
            wr.flush();
            wr.close();
            HTTPReply reply = new HTTPReply();
            InputStream inputStream = null;
            try {
                inputStream = connection.getInputStream();
                reply.result = HTTPPost.readStream(inputStream);
                reply.code = connection.getResponseCode();
                HTTPReply hTTPReply = reply;
                return hTTPReply;
            }
            catch (IOException e) {
                block10: {
                    HTTPReply hTTPReply;
                    block11: {
                        inputStream = connection.getErrorStream();
                        if (inputStream == null) break block10;
                        reply.result = HTTPPost.readStream(inputStream);
                        reply.code = connection.getResponseCode();
                        hTTPReply = reply;
                        if (connection == null) break block11;
                        connection.disconnect();
                    }
                    return hTTPReply;
                }
                throw e;
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static String readStream(InputStream is) throws IOException {
        String line;
        BufferedReader rd = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        while ((line = rd.readLine()) != null) {
            response.append(line);
            response.append('\r');
        }
        rd.close();
        return response.toString();
    }
}

