/*
 * Decompiled with CFR 0.152.
 */
package org.craftland.launcher.loader;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.craftland.launcher.loader.Download;
import org.craftland.launcher.loader.PlatformUtils;
import org.craftland.launcher.loader.SettingsHandler;
import org.craftland.launcher.loader.VersionHandler;

public class MainLauncher
extends JFrame {
    static final String nameMainClassLoader = "org.craftland.launcher.loader.MainLauncher";
    static final String nameMainClassLauncher = "org.craftland.launcher.Main";
    static String[] args_temp;
    public static SettingsHandler settings;
    private final VersionHandler version;
    private final JProgressBar progressBar;
    public JLabel status = new JLabel();
    public static volatile boolean forceUpdate;
    public static IP_STACK_PREFERRED preferedNetStack;

    public MainLauncher() {
        this.version = new VersionHandler();
        Rectangle dim = this.getGraphicsConfiguration().getBounds();
        int x = 350;
        int y = 90;
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(MainLauncher.class.getResource("/org/craftland/launcher/loader/favicon.png")));
        this.setResizable(false);
        this.setTitle("Craftland LauncherLoader");
        this.setDefaultCloseOperation(3);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(contentPane);
        contentPane.setLayout(null);
        this.status.setText("Checking for new launcher version");
        contentPane.add(this.status);
        contentPane.add(this.progressBar);
        this.setBounds((dim.width - x) / 2, (dim.height - y) / 2, x, y);
        this.progressBar.setBounds(15, y - 55, x - 30, 24);
        this.status.setBounds(15, 8, x - 30, 20);
        this.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("--portable")) {
                    PlatformUtils.setPortable(true);
                    continue;
                }
                if (args[i].equals("--url") & i + 1 < args.length) {
                    VersionHandler.launcherURL = args[++i].replaceAll("'|\"", "");
                    System.out.println("Using custom launcher url '" + VersionHandler.launcherURL + "'");
                    continue;
                }
                if (args[i].equals("--preferipv4")) {
                    preferedNetStack = IP_STACK_PREFERRED.IPV4;
                    continue;
                }
                if (!args[i].equals("--preferipv6")) continue;
                preferedNetStack = IP_STACK_PREFERRED.IPV6;
            }
            args_temp = args;
            MainLauncher.initSettings();
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            MainLauncher mainFrame = new MainLauncher();
            mainFrame.setVisible(true);
            mainFrame.onLoad();
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(null, e.toString(), e.getClass().getSimpleName(), 0);
        }
    }

    private static void initSettings() {
        new File(PlatformUtils.getWorkingDirectory(), "config").mkdirs();
        File oldFile = new File(PlatformUtils.getWorkingDirectory(), "mods" + File.separator + "craftland" + File.separator + "craftland.properties");
        File launcherProperties = new File(PlatformUtils.getWorkingDirectory(), "config" + File.separator + "launcher.properties");
        if (oldFile.exists()) {
            oldFile.renameTo(launcherProperties);
        }
        settings = new SettingsHandler("/defaults/craftland.properties", launcherProperties);
        settings.load();
    }

    void handleNetExc(Exception e) {
        this.setAlwaysOnTop(false);
        JOptionPane.showMessageDialog(this, e.toString(), "Can't load versions.txt", 0);
        Object[] options = new Object[]{"Try again with IPv4", "Try again with IPv6", "Quit"};
        Object selOpt = options[0];
        int optPick = JOptionPane.showOptionDialog(this, "Failed connecting to craftland.org\nPlease check your internet connection.\nPlease visit www.craftland.org for help\n\nPlease choose", "Can't load versions.txt", 1, 0, null, options, selOpt);
        if (optPick >= 0 && optPick < 2) {
            preferedNetStack = IP_STACK_PREFERRED.values()[optPick];
            String pathSelfJar = null;
            try {
                pathSelfJar = new File(MainLauncher.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
                MainLauncher.restartSelf(pathSelfJar, new String[0], new String[0]);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                Object strErrMsg = "Failed relaunching with ";
                switch (preferedNetStack) {
                    case IPV4: {
                        strErrMsg = (String)strErrMsg + "--preferipv4";
                        break;
                    }
                    case IPV6: {
                        strErrMsg = (String)strErrMsg + "--preferipv6";
                        break;
                    }
                }
                strErrMsg = (String)strErrMsg + e.toString();
                System.err.println((String)strErrMsg);
                JOptionPane.showMessageDialog(this, strErrMsg, "Can't load versions.txt", 0);
            }
        } else {
            System.exit(1);
        }
    }

    private void onLoad() {
        Thread updateThread = new Thread(() -> {
            block19: {
                System.out.println("Update thread...");
                System.out.println("Working dir: " + PlatformUtils.getWorkingDirectory().getAbsolutePath());
                System.out.println("Launcher dir: " + PlatformUtils.getLauncherDirectory().getAbsolutePath());
                System.out.println("Java exe: " + MainLauncher.getJavaExe());
                new File(PlatformUtils.getLauncherDirectory(), "../lib").mkdirs();
                boolean update = !MainLauncher.getJarPath().exists();
                double local = 0.0;
                File versionFile = new File(PlatformUtils.getWorkingDirectory(), "launcherversion.txt");
                try {
                    Thread.sleep(600L);
                    if (forceUpdate || update) {
                        if (MainLauncher.getJarPath().exists()) {
                            JOptionPane.showMessageDialog(this, "Forcing update!", "Loader", 1);
                        }
                        if (versionFile.exists()) {
                            versionFile.delete();
                        }
                    }
                    this.version.loadVersions(this);
                }
                catch (UnknownHostException e) {
                    System.err.println(e.toString());
                    this.handleNetExc(e);
                    return;
                }
                catch (SocketException e) {
                    System.err.println(e.toString());
                    this.handleNetExc(e);
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.setAlwaysOnTop(false);
                    JOptionPane.showMessageDialog(this, e.toString(), "Can't load versions.txt", 0);
                    return;
                }
                if (versionFile.exists()) {
                    try {
                        local = Double.parseDouble(VersionHandler.readVersionFile(versionFile));
                        update = local != this.version.getVersion("newlauncher");
                        System.out.println("should update: " + update + ": local = " + local + ", new = " + this.version.getVersion("newlauncher"));
                    }
                    catch (Exception e) {
                        this.setAlwaysOnTop(false);
                        JOptionPane.showMessageDialog(this, e.toString(), "Can't read " + versionFile.getPath(), 0);
                        update = true;
                    }
                } else {
                    update = true;
                }
                if (update) {
                    this.status.setText("New launcher version found: " + this.version.getVersion("newlauncher"));
                    String url = this.version.getURL("newlauncher");
                    try {
                        File launcher = MainLauncher.getJarPath();
                        if (launcher.exists()) {
                            launcher.delete();
                        }
                        Download launcherDownload = new Download(this, url, launcher.getPath());
                        launcherDownload.load();
                        if (launcher.exists()) {
                            VersionHandler.writeVersionFile(versionFile, String.valueOf(this.version.getVersion("newlauncher")));
                            MainLauncher.reboot(true);
                            break block19;
                        }
                        this.status.setForeground(Color.RED);
                        this.status.setText("Update failed!");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.status.setForeground(Color.RED);
                        this.status.setText("Update failed!");
                        this.setAlwaysOnTop(false);
                        JOptionPane.showMessageDialog(this, e.toString() + " while loading " + url, "Update failed", 0);
                    }
                } else {
                    String javaname = "Java " + System.getProperty("java.version") + " " + System.getProperty("os.arch");
                    this.status.setText("Starting launcher (" + javaname + ")");
                    try {
                        MainLauncher.reboot(false);
                    }
                    catch (Throwable e) {
                        JOptionPane.showMessageDialog(null, e.toString(), e.getClass().getSimpleName(), 0);
                    }
                }
            }
        });
        updateThread.setDaemon(true);
        updateThread.start();
    }

    public static File getJarPath() {
        return new File(PlatformUtils.getLauncherDirectory(), "../lib" + File.separator + "launcher.jar");
    }

    public static void restartSelf(String ownPath, String[] extraJREArgs, String[] extraProgramArgs) throws Exception {
        ArrayList<String> params = new ArrayList<String>();
        params.add(MainLauncher.getJavaExe());
        switch (preferedNetStack) {
            case IPV4: {
                params.add("-Djava.net.preferIPv4Stack=true");
                params.add("-Djava.net.preferIPv6Addresses=false");
                break;
            }
            case IPV6: {
                params.add("-Djava.net.preferIPv4Stack=false");
                params.add("-Djava.net.preferIPv6Addresses=true");
                break;
            }
        }
        Collections.addAll(params, extraJREArgs);
        if (System.getProperty("launcher.jredir") != null) {
            params.add("-Dlauncher.jredir=" + System.getProperty("launcher.jredir"));
        }
        params.add("-cp");
        params.add(MainLauncher.getJarPath().getParentFile().getAbsolutePath() + File.separator + "*");
        params.add(nameMainClassLoader);
        MainLauncher.addIPParams(params);
        Collections.addAll(params, extraProgramArgs);
        System.out.println(params);
        ProcessBuilder pb = new ProcessBuilder(params);
        pb.directory(PlatformUtils.getLauncherDirectory());
        Process process = pb.start();
        if (process == null) {
            throw new Exception("ProcessBuilder start() process == null");
        }
        System.exit(0);
    }

    public static String getJavaExe() {
        File f;
        Object commandName = null;
        String javaHome = System.getProperty("launcher.jredir");
        if (javaHome != null && (f = new File(javaHome, "bin")).isDirectory()) {
            commandName = f.getAbsolutePath() + File.separator + "java";
        }
        if (Files.exists(Path.of("../bin/java", new String[0]), new LinkOption[0])) {
            commandName = Path.of("../bin/java", new String[0]).toAbsolutePath().toString();
            System.out.println("Loader using craftland runtime");
        }
        if (Files.exists(Path.of("../bin/java.exe", new String[0]), new LinkOption[0])) {
            commandName = Path.of("../bin/java.exe", new String[0]).toAbsolutePath().toString();
            System.out.println("Loader using craftland runtime");
        }
        if (commandName == null) {
            commandName = "java";
            System.out.println("Loader using java from path");
        }
        return commandName;
    }

    public static void reboot(boolean nag) throws Exception {
        int result;
        int n = result = nag ? JOptionPane.showConfirmDialog(null, "The launcher needs to be restarted to apply changes.\nRestart now?", "Launcher updated", 0) : 0;
        if (result == 0) {
            String lineErr;
            ArrayList<String> params = new ArrayList<String>();
            params.add(MainLauncher.getJavaExe());
            switch (preferedNetStack) {
                case IPV4: {
                    params.add("-Djava.net.preferIPv4Stack=true");
                    params.add("-Djava.net.preferIPv6Addresses=false");
                    break;
                }
                case IPV6: {
                    params.add("-Djava.net.preferIPv4Stack=false");
                    params.add("-Djava.net.preferIPv6Addresses=true");
                    break;
                }
            }
            if (PlatformUtils.getPlatform() == PlatformUtils.OS.macos) {
                params.add("-Xdock:name=Craftland");
            }
            if (System.getProperty("launcher.jredir") != null) {
                params.add("-Dlauncher.jredir=" + System.getProperty("launcher.jredir"));
            }
            params.add("-cp");
            params.add(MainLauncher.getJarPath().getParentFile().getAbsolutePath() + File.separator + "*");
            params.add(nameMainClassLauncher);
            Collections.addAll(params, args_temp);
            MainLauncher.addIPParams(params);
            System.out.println(String.join((CharSequence)" ", params));
            ProcessBuilder pb = new ProcessBuilder(params).redirectErrorStream(true);
            pb.directory(PlatformUtils.getLauncherDirectory());
            Process process = pb.start();
            Thread.sleep(400L);
            BufferedReader is = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            boolean goodstart = false;
            Object response = "";
            while ((line = is.readLine()) != null) {
                if (line.equalsIgnoreCase("OK_OK")) {
                    goodstart = true;
                    break;
                }
                response = (String)response + line + "\n";
            }
            is.close();
            System.out.println("Response: " + (String)response);
            BufferedReader iserr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            StringBuilder responseErr = new StringBuilder();
            while ((lineErr = iserr.readLine()) != null) {
                responseErr.append(lineErr).append("\n");
            }
            iserr.close();
            System.out.println("Error output: " + responseErr);
            if (!goodstart) {
                String strReport = "Please report this error.\n";
                if (((String)response).contains("program requires Java")) {
                    strReport = "";
                }
                String errStr = "Failed to start Java Process.\n" + strReport + (String)(((String)response).isEmpty() ? "" : response);
                System.err.println(errStr);
                JOptionPane.showMessageDialog(null, errStr, "Failed to start", 2);
                if (!strReport.isEmpty()) {
                    File versionFile = new File(PlatformUtils.getWorkingDirectory(), "launcherversion.txt");
                    VersionHandler.writeVersionFile(versionFile, String.valueOf(0));
                }
            }
            System.exit(0);
        }
    }

    private static void addIPParams(ArrayList<String> params) {
        switch (preferedNetStack) {
            case IPV4: {
                params.add("--preferipv4");
                break;
            }
            case IPV6: {
                params.add("--preferipv6");
                break;
            }
        }
    }

    public void stateChanged(String fileName, float progress) {
        int intProgress = Math.round(progress);
        this.progressBar.setValue(intProgress);
        this.progressBar.setString(intProgress + "% " + fileName);
    }

    static {
        forceUpdate = false;
        preferedNetStack = IP_STACK_PREFERRED.NONE;
    }

    public static enum IP_STACK_PREFERRED {
        IPV4,
        IPV6,
        NONE;

    }
}

